% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggs_pcp.R
\name{ggs_pcp}
\alias{ggs_pcp}
\title{Plot for model fit of binary response variables: percent correctly predicted}
\usage{
ggs_pcp(D, outcome, threshold = "observed", bins = 30)
}
\arguments{
\item{D}{Data frame whith the simulations. Notice that only the fitted / expected posterior outcomes are needed, and so either the previous call to ggs() should have limited the family of parameters to only pass the fitted / expected values. See the example below.}

\item{outcome}{vector (or matrix or array) containing the observed outcome variable. Currently only a vector is supported.}

\item{threshold}{numerical bounded between 0 and 1 or "observed", the default. If "observed", the threshold of expected values to be considered a realization of the event (1, succes) is computed using the observed value in the data. Otherwise, a numerical value showing which threshold to use (typically, 0.5) can be given.}

\item{bins}{integer indicating the total number of bins in which to divide the histogram. Defaults to 30, which is the same as geom_histogram()}
}
\value{
A \code{ggplot} object
}
\description{
Plot a histogram with the distribution of correctly predicted cases in a model against a binary response variable.
}
\examples{
data(binary)
ggs_pcp(ggs(s.binary, family="mu"), outcome=y.binary)
}
