% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggmotif.R
\name{ggmotif}
\alias{ggmotif}
\title{ggmotif}
\usage{
ggmotif(
  msa,
  start = NULL,
  end = NULL,
  font = "helvetical",
  color = "Chemistry_NT"
)
}
\arguments{
\item{msa}{Multiple aligned sequence file or object for
representing either nucleotide sequences or peptide sequences.}

\item{start}{Start position to plot, If font=NULL, only the background frame is drawn, and no character.}

\item{end}{End position to plot,If font=NULL, only the background frame is drawn, and no character.}

\item{font}{font families, possible values are 'helvetical', 'mono', and 'DroidSansMono', 'TimesNewRoman'.  Defaults is 'helvetical'.}

\item{color}{A Color scheme. One of 'Chemistry_NT', 'Shapely_NT', 'Zappo_NT', 'Taylor_NT'. Defaults is 'Chemistry_NT'.}
}
\value{
ggplot object
}
\description{
plot sequence motif for nucleotide sequences based 'ggolot2'
}
\examples{
#plot sequence motif independently
nt_sequence <- system.file("extdata", "LeaderRepeat_All.fa", package = "ggmsa")
ggmotif(nt_sequence, color = "Chemistry_NT")
}
\author{
Lang Zhou
}
