% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MullerPlot.R
\name{reorder_by_vector}
\alias{reorder_by_vector}
\title{Reorder a Muller plot dataframe by a vector}
\usage{
reorder_by_vector(df, vector)
}
\arguments{
\item{df}{Dataframe with column names "Identity", "Parent", and either "Generation" or "Time", in which each Identity appears exactly twice}

\item{vector}{Vector of Identity values}
}
\value{
The reordered dataframe.
}
\description{
Reorder a Muller plot dataframe by a vector
}
\examples{
df <- data.frame(Generation = c(rep(0, 6), rep(1, 6)), 
 Identity = rep(1:6,2), Population = c(1, rep(0, 5), 10, rep(1, 5)))
df <- rbind(df, df) # duplicate rows
require(dplyr)
df <- arrange(df, Generation) # put in chronological order
edges1 <- data.frame(Parent = c(1,1,1,3,3), Identity = 2:6) # adjacency matrix
path <- path_vector(edges1) # path through the adjacency matrix
reorder_by_vector(df, path)

}
\seealso{
\code{\link{path_vector}}
}
\author{
Rob Noble, \email{robjohnnoble@gmail.com}
}
