% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom-serialaxes-density.R,
%   R/stat-serialaxes-density.R
\name{geom_serialaxes_density}
\alias{geom_serialaxes_density}
\alias{stat_serialaxes_density}
\title{Smoothed density estimates for "widens" data under serial axes coordinate}
\usage{
geom_serialaxes_density(
  mapping = NULL,
  data = NULL,
  stat = "serialaxes_density",
  position = "identity_",
  ...,
  axes.sequence = character(0L),
  merge = TRUE,
  scale.y = c("data", "variable"),
  as.mix = TRUE,
  positive = TRUE,
  adjust = 0.9,
  na.rm = FALSE,
  orientation = NA,
  show.legend = NA,
  inherit.aes = TRUE
)

stat_serialaxes_density(
  mapping = NULL,
  data = NULL,
  geom = "serialaxes_density",
  position = "stack_",
  ...,
  axes.sequence = character(0L),
  merge = TRUE,
  axes.position = NULL,
  scaling = c("data", "variable", "observation", "none"),
  bw = "nrd0",
  adjust = 1,
  kernel = "gaussian",
  n = 512,
  trim = FALSE,
  na.rm = FALSE,
  orientation = NA,
  show.legend = NA,
  inherit.aes = TRUE
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}} or
\code{\link[ggplot2:aes_]{aes_()}}. If specified and \code{inherit.aes = TRUE} (the
default), it is combined with the default mapping at the top level of the
plot. You must supply \code{mapping} if there is no plot mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{stat}{The statistical transformation to use on the data for this
layer, as a string.}

\item{position}{Position adjustment, either as a string, or the result of
a call to a position adjustment function.}

\item{...}{Other arguments passed on to \code{\link[ggplot2:layer]{layer()}}. These are
often aesthetics, used to set an aesthetic to a fixed value, like
\code{colour = "red"} or \code{size = 3}. They may also be parameters
to the paired geom/stat.}

\item{axes.sequence}{A vector to define the axes sequence. In serial axes coordinate, the sequence can be either
determined in \code{mapping} (function \code{aes()}) or by \code{axes.sequence}. The only difference is that
the \code{mapping} aesthetics will omit the duplicated axes (check examples in \code{\link{geom_serialaxes}}).}

\item{merge}{Should \code{axes.sequence} be merged with mapping aesthetics
as a single mapping \code{uneval} object?}

\item{scale.y}{one of 'data', 'variable' to specify.
\tabular{ll}{ \strong{Type} \tab \strong{Description}
\cr data (default) \tab The density estimates are scaled by the whole data set
\cr variable \tab The density estimates are scaled by each variable
}
If the \code{scale.y} is "data", it is meaningful to compare the density (shape and area) across all groups; else
it is only meaningful to compare the density under each variable.}

\item{as.mix}{Logical. Under each variable, if \code{as.mix = TRUE}, the sum of the density estimate area is mixed and
scaled to maximum 1. The area of each group is proportional to its own count; if \code{as.mix = FALSE}
the area of each group is the same, with maximum 1.}

\item{positive}{If \code{y} is set as the density estimate, where the smoothed curved is faced to,
right (`positive`) or left (`negative`) as vertical layout; up (`positive`) or down (`negative`) as horizontal layout?}

\item{adjust}{adjust the proportional maximum height of the estimate (density, histogram, ...).}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}

\item{orientation}{The orientation of the layer. The default (\code{NA})
automatically determines the orientation from the aesthetic mapping. In the
rare event that this fails it can be given explicitly by setting \code{orientation}
to either \code{"x"} or \code{"y"}. See the \emph{Orientation} section for more detail.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:borders]{borders()}}.}

\item{geom}{The geometric object to use display the data}

\item{axes.position}{A numerical vector to determine the axes sequence position;
the length should be the same with the length of \code{axes.sequence} (or mapping \code{aesthetics}, see examples).}

\item{scaling}{one of \code{data}, \code{variable}, \code{observation} or
\code{none} (not suggested the layout is the same with \code{data})
to specify how the data is scaled.}

\item{bw}{The smoothing bandwidth to be used.
If numeric, the standard deviation of the smoothing kernel.
If character, a rule to choose the bandwidth, as listed in
\code{\link[stats:bandwidth]{stats::bw.nrd()}}.}

\item{kernel}{Kernel. See list of available kernels in \code{\link[=density]{density()}}.}

\item{n}{number of equally spaced points at which the density is to be
estimated, should be a power of two, see \code{\link[=density]{density()}} for
details}

\item{trim}{If \code{FALSE}, the default, each density is computed on the
full range of the data. If \code{TRUE}, each density is computed over the
range of that group: this typically means the estimated x values will
not line-up, and hence you won't be able to stack density values.
This parameter only matters if you are displaying multiple densities in
one plot or if you are manually adjusting the scale limits.}
}
\description{
Computes and draws kernel density estimates on serial axes coordinate
for each non-aesthetics component defined in the mapping \code{aes()}.
}
\examples{
p <- ggplot(iris, mapping = aes(Sepal.Length = Sepal.Length,
                                Sepal.Width = Sepal.Width,
                                Petal.Length = Petal.Length,
                                Petal.Width = Petal.Width,
                                colour = Species,
                                fill = Species)) +
       geom_serialaxes(alpha = 0.2) +
       geom_serialaxes_density(alpha = 0.5) +
       scale_x_continuous(breaks = 1:4,
                          labels = colnames(iris)[-5]) +
       scale_y_continuous(labels = NULL) +
       xlab("variable") +
       ylab("") +
       theme(axis.text.x = element_text(angle = 45, vjust = 0.5))
p
}
\seealso{
\code{\link{geom_density_}}, \code{\link{geom_serialaxes}},
\code{\link{geom_serialaxes_quantile}}, \code{\link{geom_serialaxes_hist}}
}
