% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggpie.R
\name{ggpie}
\alias{ggpie}
\title{Create Pie plot.}
\usage{
ggpie(
  data,
  group_key = NULL,
  count_type = c("count", "full"),
  fill_color = NULL,
  label_info = c("count", "ratio", "all"),
  label_split = "[[:space:]]+",
  label_len = 40,
  label_color = "black",
  label_type = c("circle", "horizon", "none"),
  label_pos = c("in", "out"),
  label_gap = 0.05,
  label_threshold = NULL,
  label_size = 4,
  border_color = "black",
  border_size = 1,
  nudge_x = 1,
  nudge_y = 1
)
}
\arguments{
\item{data}{Data frame contains full data or summarized data.}

\item{group_key}{Column used to summarize the data. Default: NULL.}

\item{count_type}{Data frame type, chosen from "count" and "full". "count" means summarized data and "full" means full data. Default: count.}

\item{fill_color}{Colors used. Default: NULL (conduct automatic selection).}

\item{label_info}{Label information type, chosen from count, ratio and all (count and ratio). Default: count.}

\item{label_split}{Pattern used to split the label, support regular expression. Default: space.}

\item{label_len}{The length of label text. Used when \code{label_split} is NULL. Default: 40.}

\item{label_color}{Color of the label. Default: black.}

\item{label_type}{Label style, chosen from circle, horizon and none (no label). Default: circle.}

\item{label_pos}{Label position, chosen from in and out. Default: in.}

\item{label_gap}{Gap between label and pie plot, used when \code{label_pos} is out.}

\item{label_threshold}{Threshold of the ratio to determine label position (in/out pie). Default: NULL.}

\item{label_size}{Size of the label. Default: 4.}

\item{border_color}{Border color. Default: black.}

\item{border_size}{Border thickness. Default: 1.}

\item{nudge_x}{Parameter of \code{\link{geom_text_repel}}. Default: 1.}

\item{nudge_y}{Parameter of \code{\link{geom_text_repel}}. Default: 1.}
}
\value{
A ggplot2 object.
}
\description{
Create Pie plot.
}
\examples{
library(ggpie)
library(ggplot2)
data(diamonds)
# with no label
ggpie(
  data = diamonds, group_key = "cut", count_type = "full",
  label_info = "all", label_type = "none"
)
# circle label and out of pie
ggpie(
  data = diamonds, group_key = "cut", count_type = "full",
  label_info = "all", label_type = "circle",
  label_size = 4, label_pos = "out"
)
# circle label and in pie plot, with no split
ggpie(
  data = diamonds, group_key = "cut", count_type = "full",
  label_info = "all", label_type = "circle", label_split = NULL,
  label_size = 4, label_pos = "in"
)
# horizon label and in pie plot, with no split
ggpie(
  data = diamonds, group_key = "cut", count_type = "full",
  label_info = "all", label_type = "horizon", label_split = NULL,
  label_size = 4, label_pos = "in"
)
# horizon label and in pie plot, split with space
ggpie(
  data = diamonds, group_key = "cut", count_type = "full",
  label_info = "all", label_type = "horizon",
  label_size = 4, label_pos = "in"
)
# horizon label and out pie plot, with no split
ggpie(
  data = diamonds, group_key = "cut", count_type = "full",
  label_info = "all", label_type = "horizon", label_split = NULL,
  label_size = 4, label_pos = "out"
)
# with label threshold
ggpie(
  data = diamonds, group_key = "cut", count_type = "full",
  label_info = "all", label_type = "horizon", label_split = NULL,
  label_size = 4, label_pos = "in", label_threshold = 10
)
}
