\name{geom_bin2d}
\alias{geom_bin2d}
\alias{GeomBin2d}
\title{geom\_bin2d}
\description{Add heatmap of 2d bin counts}
\details{
This page describes geom\_bin2d, see \code{\link{layer}} and \code{\link{qplot}} for how to create a complete plot from individual components.
}
\section{Aesthetics}{
The following aesthetics can be used with geom\_bin2d.  Aesthetics are mapped to variables in the data with the \code{\link{aes}} function: \code{geom\_bin2d(\code{\link{aes}}(x = var))}
\itemize{
  \item \code{xmin}: left (hortizontal minimum) (\strong{required}) 
  \item \code{xmax}: right (hortizontal maximum) (\strong{required}) 
  \item \code{ymin}: bottom (vertical minimum) (\strong{required}) 
  \item \code{ymax}: top (vertical maximum) (\strong{required}) 
  \item \code{colour}: border colour 
  \item \code{fill}: internal colour 
  \item \code{size}: size 
  \item \code{linetype}: line type 
  \item \code{weight}: observation weight used in statistical transformation 
  \item \code{alpha}: transparency 
}
}
\usage{geom_bin2d(mapping=NULL, data=NULL, stat="bin2d", position="identity", ...)}
\arguments{
 \item{mapping}{mapping between variables and aesthetics generated by aes}
 \item{data}{dataset used in this layer, if not specified uses plot dataset}
 \item{stat}{statistic used by this layer}
 \item{position}{position adjustment used by this layer}
 \item{...}{ignored }
}
\seealso{\itemize{
  \item \url{http://had.co.nz/ggplot2/geom_bin2d.html}
}}
\value{A \code{\link{layer}}}
\examples{\dontrun{
# See ?stat_bin2d
}}
\author{Hadley Wickham, \url{http://had.co.nz/}}
\keyword{hplot}
