% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/scale-brewer.r, R/zxx.r
\name{scale_colour_brewer}
\alias{scale_color_brewer}
\alias{scale_color_distiller}
\alias{scale_colour_brewer}
\alias{scale_colour_distiller}
\alias{scale_fill_brewer}
\alias{scale_fill_distiller}
\title{Sequential, diverging and qualitative colour scales from colorbrewer.org}
\usage{
scale_colour_brewer(..., type = "seq", palette = 1)

scale_fill_brewer(..., type = "seq", palette = 1)

scale_colour_distiller(..., type = "seq", palette = 1, values = NULL,
  space = "Lab", na.value = "grey50")

scale_fill_distiller(..., type = "seq", palette = 1, values = NULL,
  space = "Lab", na.value = "grey50")

scale_color_brewer(..., type = "seq", palette = 1)

scale_color_distiller(..., type = "seq", palette = 1, values = NULL,
  space = "Lab", na.value = "grey50")
}
\arguments{
\item{...}{Other arguments passed on to \code{\link{discrete_scale}}
to control name, limits, breaks, labels and so forth.}

\item{type}{One of seq (sequential), div (diverging) or qual (qualitative)}

\item{palette}{If a string, will use that named palette.  If a number, will
index into the list of palettes of appropriate \code{type}}

\item{values}{if colours should not be evenly positioned along the gradient
this vector gives the position (between 0 and 1) for each colour in the
\code{colours} vector. See \code{\link{rescale}} for a convience function
to map an arbitrary range to between 0 and 1.}

\item{space}{colour space in which to calculate gradient.  "Lab" usually
best unless gradient goes through white.}

\item{na.value}{Colour to use for missing values}
}
\description{
ColorBrewer provides sequential, diverging and qualitative colour schemes
which are particularly suited and tested to display discrete values (levels
of a factor) on a map. ggplot2 can use those colours in discrete scales. It
also allows to smoothly interpolate 6 colours from any palette to a
continuous scale (6 colours per palette gives nice gradients; more results in
more saturated colours which do not look as good). However, the original
colour schemes (particularly the qualitative ones) were not intended for this
and the perceptual result is left to the appreciation of the user.
}
\details{
See \url{http://colorbrewer2.org} for more information.
}
\examples{
dsamp <- diamonds[sample(nrow(diamonds), 1000), ]
(d <- qplot(carat, price, data = dsamp, colour = clarity))

# Change scale label
d + scale_colour_brewer()
d + scale_colour_brewer("clarity")
d + scale_colour_brewer(expression(clarity[beta]))

# Select brewer palette to use, see ?scales::brewer_pal for more details
d + scale_colour_brewer(type = "seq")
d + scale_colour_brewer(type = "seq", palette = 3)

d + scale_colour_brewer(palette = "Blues")
d + scale_colour_brewer(palette = "Set1")

# scale_fill_brewer works just the same as
# scale_colour_brewer but for fill colours
ggplot(diamonds, aes(x = price, fill = cut)) +
  geom_histogram(position = "dodge", binwidth = 1000) +
  scale_fill_brewer()

# Generate map data
library(reshape2) # for melt
volcano3d <- melt(volcano)
names(volcano3d) <- c("x", "y", "z")

# Basic plot
v <- ggplot() + geom_tile(aes(x = x, y = y, fill = z), data = volcano3d)
v
v + scale_fill_distiller()
v + scale_fill_distiller(palette = 2)
v + scale_fill_distiller(type = "div")
v + scale_fill_distiller(palette = "Spectral")
v + scale_fill_distiller(palette = "Spectral", trans = "reverse")
v + scale_fill_distiller(type = "qual")
# Not appropriate for continuous data, issues a warning
}
\seealso{
Other colour scales: \code{\link{scale_color_continuous}},
  \code{\link{scale_color_gradient}},
  \code{\link{scale_colour_continuous}},
  \code{\link{scale_colour_gradient}},
  \code{\link{scale_fill_continuous}},
  \code{\link{scale_fill_gradient}};
  \code{\link{scale_color_discrete}},
  \code{\link{scale_color_hue}},
  \code{\link{scale_colour_discrete}},
  \code{\link{scale_colour_hue}},
  \code{\link{scale_fill_discrete}},
  \code{\link{scale_fill_hue}};
  \code{\link{scale_color_gradient2}},
  \code{\link{scale_colour_gradient2}},
  \code{\link{scale_fill_gradient2}};
  \code{\link{scale_color_gradientn}},
  \code{\link{scale_colour_gradientn}},
  \code{\link{scale_fill_gradientn}};
  \code{\link{scale_color_grey}},
  \code{\link{scale_colour_grey}},
  \code{\link{scale_fill_grey}}
}

