% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat-poly-line.R
\name{stat_poly_line}
\alias{stat_poly_line}
\title{Predicted line from model fit}
\usage{
stat_poly_line(
  mapping = NULL,
  data = NULL,
  geom = "smooth",
  position = "identity",
  ...,
  method = "lm",
  formula = NULL,
  se = TRUE,
  n = 80,
  span = 0.75,
  fullrange = FALSE,
  level = 0.95,
  method.args = list(),
  na.rm = FALSE,
  orientation = NA,
  show.legend = NA,
  inherit.aes = TRUE
)
}
\arguments{
\item{mapping}{The aesthetic mapping, usually constructed with
\code{\link[ggplot2]{aes}} or \code{\link[ggplot2]{aes_}}. Only needs to be
set at the layer level if you are overriding the plot defaults.}

\item{data}{A layer specific dataset, only needed if you want to override
the plot defaults.}

\item{geom}{The geometric object to use display the data}

\item{position}{The position adjustment to use for overlapping points on this
layer}

\item{...}{other arguments passed on to \code{\link[ggplot2]{layer}}. This
can include aesthetics whose values you want to set, not map. See
\code{\link[ggplot2]{layer}} for more details.}

\item{method}{function or character If character, "lm", "rlm" and
"rq" are accepted. If a function, it must have formal parameters
\code{formula} and \code{data} and return a model fit object for which
\code{summary()} and \code{coefficients()} are consistent with those for
\code{lm} fits.}

\item{formula}{a formula object. Using aesthetic names \code{x} and \code{y}
instead of original variable names.}

\item{se}{Display confidence interval around smooth? (`TRUE` by default, see
`level` to control.)}

\item{n}{Number of points at which to evaluate smoother.}

\item{span}{Controls the amount of smoothing for the default loess smoother.
Smaller numbers produce wigglier lines, larger numbers produce smoother
lines. Only used with loess, i.e. when `method = "loess"`,
or when `method = NULL` (the default) and there are fewer than 1,000
observations.}

\item{fullrange}{Should the fit span the full range of the plot, or just
the data?}

\item{level}{Level of confidence interval to use (0.95 by default).}

\item{method.args}{named list with additional arguments.}

\item{na.rm}{a logical indicating whether NA values should be stripped before
the computation proceeds.}

\item{orientation}{character Either "x" or "y" controlling the default for
\code{formula}.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped. \code{FALSE}
never includes, and \code{TRUE} always includes.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics, rather
than combining with them. This is most useful for helper functions that
define both data and aesthetics and shouldn't inherit behaviour from the
default plot specification, e.g. \code{\link[ggplot2]{borders}}.}
}
\value{
The value returned by the statistic is a data frame, that will have
  \code{n} rows of predicted values and and their confidence limits.
}
\description{
Predicted values and a confidence band are computed and, by default, plotted.
\code{stat_poly_line()} behaves like \code{\link[ggplot2]{stat_smooth}}
except for supporting the use of \code{y} as explanatory variable in the
model formula, fits the model with \code{stats::lm()} as default for
\code{method}, irrespective of the number of observations. The fit can
alternatively by done by any of the methods supported by
\code{\link[ggplot2]{stat_smooth}}, including \code{method = "auto"}.
}
\details{
This statistic is just \code{\link[ggplot2]{stat_smooth}} with different
defaults and updated so that it interprets the argument passed to
\code{formula} differently, accepting \code{y} as explanatory variable and
setting \code{orientation} automatically. In addition the default for
\code{method} is \code{"lm"}, matching the default used in
\code{stat_poly_eq()} and \code{stat_poly_quant()}. It calls
\code{\link[ggplot2]{StatSmooth}} to build a layer.

\code{\link[ggplot2]{geom_smooth}}, which is used by default, treats each
axis differently and can thus have two orientations. The orientation is easy
to deduce from the argument passed to \code{formula}. Thus,
\code{stat_smooth_xy()} will by default guess which orientation the layer
should have. If no argument is passed to \code{formula}, the orientation is
ambiguous. In that case the orientation can be specified directly passing an
argument to the \code{orientation} parameter, which can be either \code{"x"}
or \code{"y"}. The value gives the axis that is taken as the explanatory
variable, \code{"x"} being the default orientation you would expect for the
geom. Package 'ggpmisc' does not define new geometries matching the new
statistics as they are not needed and conceptually transformations of
\code{data} are expressed as statistics.
}
\section{Computed variables}{
 `stat_smooth_xy()` provides the following
  variables, some of which depend on the orientation: \describe{ \item{y *or*
  x}{predicted value} \item{ymin *or* xmin}{lower pointwise confidence
  interval around the mean} \item{ymax *or* xmax}{upper pointwise confidence
  interval around the mean} \item{se}{standard error} }
}

\section{Aesthetics}{
 \code{stat_poly_eq} understands \code{x} and \code{y},
  to be referenced in the \code{formula} and \code{weight} passed as argument
  to parameter \code{weights}. All three must be mapped to \code{numeric}
  variables. In addition, the aesthetics understood by the geom
  (\code{"geom_smooth"} is the default) are understood and grouping
  respected.
}

\examples{
ggplot(mpg, aes(displ, hwy)) +
  geom_point() +
  stat_poly_line()

ggplot(mpg, aes(displ, hwy)) +
  geom_point() +
  stat_poly_line(formula = x ~ y)

ggplot(mpg, aes(displ, hwy)) +
  geom_point() +
  stat_poly_line(formula = y ~ poly(x, 3))

ggplot(mpg, aes(displ, hwy)) +
  geom_point() +
  stat_poly_line(formula = x ~ poly(y, 3))

# The default behavior of geom_smooth()
ggplot(mpg, aes(displ, hwy)) +
  geom_point() +
  stat_poly_line(method = "auto")

# Use span to control the "wiggliness" of the default loess smoother.
# The span is the fraction of points used to fit each local regression:
# small numbers make a wigglier curve, larger numbers make a smoother curve.
ggplot(mpg, aes(displ, hwy)) +
  geom_point() +
  stat_poly_line(method = "loess", span = 0.3)

ggplot(mpg, aes(displ, hwy)) +
  geom_point() +
  stat_poly_line(method = lm, formula = y ~ splines::bs(x, 3), se = FALSE)

ggplot(mpg, aes(displ, hwy)) +
  geom_point() +
  stat_poly_line(method = lm, formula = x ~ splines::bs(y, 3), se = FALSE)

# Smooths are automatically fit to each group (defined by categorical
# aesthetics or the group aesthetic) and for each facet.

ggplot(mpg, aes(displ, hwy, colour = class)) +
  geom_point() +
  stat_poly_line(se = FALSE)

ggplot(mpg, aes(displ, hwy)) +
  geom_point() +
  stat_poly_line(method = "auto", span = 0.8) +
  facet_wrap(~drv)

}
\seealso{
Other ggplot statistics for linear and polynomial regression: 
\code{\link{stat_poly_eq}()}
}
\concept{ggplot statistics for linear and polynomial regression}
