% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat-quant-band.r
\name{stat_quant_band}
\alias{stat_quant_band}
\title{Predicted band from quantile regression fits}
\usage{
stat_quant_band(
  mapping = NULL,
  data = NULL,
  geom = "smooth",
  position = "identity",
  ...,
  quantiles = c(0.25, 0.5, 0.75),
  formula = NULL,
  fm.values = FALSE,
  n = 80,
  method = "rq",
  method.args = list(),
  na.rm = FALSE,
  orientation = NA,
  show.legend = NA,
  inherit.aes = TRUE
)
}
\arguments{
\item{mapping}{The aesthetic mapping, usually constructed with
\code{\link[ggplot2]{aes}}. Only needs to be
set at the layer level if you are overriding the plot defaults.}

\item{data}{A layer specific dataset, only needed if you want to override
the plot defaults.}

\item{geom}{The geometric object to use display the data.}

\item{position}{The position adjustment to use for overlapping points on this
layer.}

\item{...}{other arguments passed on to \code{\link[ggplot2]{layer}}. This
can include aesthetics whose values you want to set, not map. See
\code{\link[ggplot2]{layer}} for more details.}

\item{quantiles}{numeric vector Two or three values in 0..1 indicating the
quantiles at the  edges of the band and optionally a line within the band.}

\item{formula}{a formula object. Using aesthetic names \code{x} and \code{y}
instead of original variable names.}

\item{fm.values}{logical Add n as a column to returned data? (`FALSE` by
default.)}

\item{n}{Number of points at which to evaluate smoother.}

\item{method}{function or character If character, "rq", "rqss" or the name of
a model fit function are accepted, possibly followed by the fit function's
\code{method} argument separated by a colon (e.g. \code{"rq:br"}). If a
function different to \code{rq()}, it must accept arguments named
\code{formula}, \code{data}, \code{weights}, \code{tau} and \code{method}
and return a model fit object of class \code{rq}, \code{rqs} or
\code{rqss}.}

\item{method.args}{named list with additional arguments.}

\item{na.rm}{a logical indicating whether NA values should be stripped before
the computation proceeds.}

\item{orientation}{character Either "x" or "y" controlling the default for
\code{formula}.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped. \code{FALSE}
never includes, and \code{TRUE} always includes.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics, rather
than combining with them. This is most useful for helper functions that
define both data and aesthetics and shouldn't inherit behaviour from the
default plot specification, e.g. \code{\link[ggplot2]{borders}}.}
}
\value{
The value returned by the statistic is a data frame, that will have
  \code{n} rows of predicted values for three quantiles as \code{y},
  \code{ymin} and \code{ymax}, plus \code{x}.
}
\description{
Predicted values are computed and, by default, plotted as a band plus an
optional line within. \code{stat_quant_band()} supports the use of both
\code{x} and \code{y} as explanatory variable in the model formula.
}
\details{
This statistic is similar to \code{\link{stat_quant_line}} but plots the
quantiles differently with the band representing a region between two
quantiles, while in \code{stat_quant_line()} the bands plotted when
\code{se = TRUE} represent confidence intervals for the fitted quantile
lines.


\code{\link[ggplot2]{geom_smooth}}, which is used by default, treats each
axis differently and thus is dependent on orientation. If no argument is
passed to \code{formula}, it defaults to \code{y ~ x} but \code{x ~y} is also
accepted, and equivalent to \code{y ~ x} plus \code{orientation = "y"}.
Package 'ggpmisc' does not define a new geometry matching this statistic as
it is enough for the statistic to return suitable `x` and `y` values.
}
\section{Aesthetics}{
 \code{stat_quant_eq} expects \code{x} and \code{y},
  aesthetics to be used in the \code{formula} rather than the names of the
  variables mapped to them. If present, the variable mapped to the
  \code{weight} aesthetics is passed as argument to parameter \code{weights}
  of the fitting function. All three must be mapped to \code{numeric}
  variables. In addition, the aesthetics recognized by the geometry
  (\code{"geom_smooth"} is the default) are obeyed and grouping
  respected.
}

\examples{
ggplot(mpg, aes(displ, hwy)) +
  geom_point() +
  stat_quant_band()

# If you need the fitting to be done along the y-axis set the orientation
ggplot(mpg, aes(displ, hwy)) +
  geom_point() +
  stat_quant_band(orientation = "y")

ggplot(mpg, aes(displ, hwy)) +
  geom_point() +
  stat_quant_band(formula = y ~ x)

ggplot(mpg, aes(displ, hwy)) +
  geom_point() +
  stat_quant_band(formula = x ~ y)

ggplot(mpg, aes(displ, hwy)) +
  geom_point() +
  stat_quant_band(formula = y ~ poly(x, 3))

ggplot(mpg, aes(displ, hwy)) +
  geom_point() +
  stat_quant_band(formula = x ~ poly(y, 3))

# Instead of rq() we can use rqss() to fit an additive model:
ggplot(mpg, aes(displ, hwy)) +
  geom_point() +
  stat_quant_band(method = "rqss",
                  formula = y ~ qss(x))

ggplot(mpg, aes(displ, hwy)) +
  geom_point() +
  stat_quant_band(method = "rqss",
                  formula = x ~ qss(y, constraint = "D"))

# Regressions are automatically fit to each group (defined by categorical
# aesthetics or the group aesthetic) and for each facet.

ggplot(mpg, aes(displ, hwy, colour = class)) +
  geom_point() +
  stat_quant_band(formula = y ~ x)

ggplot(mpg, aes(displ, hwy)) +
  geom_point() +
  stat_quant_band(formula = y ~ poly(x, 2)) +
  facet_wrap(~drv)

ggplot(mpg, aes(displ, hwy)) +
  geom_point() +
  stat_quant_band(linetype = "dashed", color = "darkred", fill = "red")

ggplot(mpg, aes(displ, hwy)) +
  stat_quant_band(color = NA, alpha = 1) +
  geom_point()

ggplot(mpg, aes(displ, hwy)) +
  stat_quant_band(quantiles = c(0, 0.1, 0.2)) +
  geom_point()

# Inspecting the returned data using geom_debug()
gginnards.installed <- requireNamespace("gginnards", quietly = TRUE)

if (gginnards.installed)
  library(gginnards)

if (gginnards.installed)
  ggplot(mpg, aes(displ, hwy)) +
    stat_quant_band(geom = "debug")

if (gginnards.installed)
  ggplot(mpg, aes(displ, hwy)) +
    stat_quant_band(geom = "debug", fm.values = TRUE)

}
\seealso{
Other ggplot statistics for quantile regression: 
\code{\link{stat_quant_eq}()},
\code{\link{stat_quant_line}()}
}
\concept{ggplot statistics for quantile regression}
