% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/guide_prism_offset_minor.R
\name{guide_prism_offset_minor}
\alias{guide_prism_offset_minor}
\title{Offset axis guide with minor ticks}
\usage{
guide_prism_offset_minor(
  title = waiver(),
  check.overlap = FALSE,
  angle = NULL,
  n.dodge = 1,
  order = 0,
  position = waiver()
)
}
\arguments{
\item{title}{A character string or expression indicating a title of guide.
If \code{NULL}, the title is not shown. By default
(\code{\link[ggplot2:waiver]{waiver()}}), the name of the scale object or the name
specified in \code{\link[ggplot2:labs]{labs()}} is used for the title.}

\item{check.overlap}{silently remove overlapping labels,
(recursively) prioritizing the first, last, and middle labels.}

\item{angle}{Compared to setting the angle in \code{\link[ggplot2:theme]{theme()}} / \code{\link[ggplot2:element_text]{element_text()}},
this also uses some heuristics to automatically pick the \code{hjust} and \code{vjust} that
you probably want.}

\item{n.dodge}{The number of rows (for vertical axes) or columns (for
horizontal axes) that should be used to render the labels. This is
useful for displaying labels that would otherwise overlap.}

\item{order}{Used to determine the order of the guides (left-to-right,
top-to-bottom), if more than one  guide must be drawn at the same location.}

\item{position}{Where this guide should be drawn: one of top, bottom,
left, or right.}
}
\value{
Returns a \emph{prism_offset_minor} guide class object.
}
\description{
This guide draws the axis only as wide as the outermost tick marks,
similar to offset axes from Prism. It also adds minor ticks.
}
\details{
Control the length of the axis by adjusting the \code{breaks} argument in
\verb{scale_(x|y)_continuous()} or \verb{scale_(x|y)_discrete()}. Similarly,
the number of minor ticks can be changed using the \code{minor_breaks}
argument.

Control the length of minor ticks by setting \code{prism.ticks.length} to
a \code{\link[grid]{unit}} object using \code{\link[ggplot2]{theme}},
for example: \code{prism.ticks.length = unit(2, "pt")}. The major tick
lengths are adjusted using the standard \code{axis.ticks.length}.
}
\examples{
library(ggplot2)

## base plot
base <- ggplot(mtcars, aes(x = wt, y = mpg)) +
  geom_point() +
  theme(axis.line = element_line(colour = "black"))

## add minor ticks to x and y axes
base +
  scale_x_continuous(
    limits = c(0, 6),
    guide = "prism_offset_minor"
  ) +
  scale_y_continuous(
    limits = c(10, 35),
    guide = "prism_offset_minor"
  )

## you can also use the guides function to add minor ticks
base +
  guides(x = "prism_offset_minor", y = "prism_offset_minor")

## adjust number of minor ticks by adjusting minor breaks
base +
  scale_x_continuous(
    limits = c(0, 6),
    minor_breaks = seq(0, 6, 0.5),
    guide = "prism_offset_minor"
  ) +
  scale_y_continuous(
    limits = c(10, 35),
    minor_breaks = seq(10, 35, 1.25),
    guide = "prism_offset_minor"
  )

## adjust the length of major ticks with the usual axis.ticks.length element
base +
  scale_x_continuous(
    limits = c(0, 6),
    minor_breaks = seq(0, 6, 0.5),
    guide = "prism_offset_minor"
  ) +
  scale_y_continuous(
    limits = c(10, 35),
    minor_breaks = seq(10, 35, 1.25),
    guide = "prism_offset_minor"
  ) +
  theme(
    axis.ticks.length = unit(10, "pt")
  )

## adjust the length of minor ticks with a new prism.ticks.length element
base +
  scale_x_continuous(
    limits = c(0, 6),
    minor_breaks = seq(0, 6, 0.5),
    guide = "prism_offset_minor"
  ) +
  scale_y_continuous(
    limits = c(10, 35),
    minor_breaks = seq(10, 35, 1.25),
    guide = "prism_offset_minor"
  ) +
  theme(
    axis.ticks.length = unit(10, "pt"),
    prism.ticks.length = unit(5, "pt")
  )

## to get log10 minor ticks just use a log10 scale and set the minor breaks
ggplot(msleep, aes(bodywt, brainwt)) +
  geom_point(na.rm = TRUE) +
  scale_x_log10(limits = c(1e0, 1e4),
                minor_breaks = rep(1:9, 4)*(10^rep(0:3, each = 9)),
                guide = "prism_offset_minor") +
  theme(axis.line = element_line(colour = "black"))

## change colour and tick length with the usual elements
base +
  scale_x_continuous(
    limits = c(0, 6),
    minor_breaks = seq(0, 6, 0.5),
    guide = "prism_offset_minor"
  ) +
  scale_y_continuous(
    limits = c(10, 35),
    minor_breaks = seq(10, 35, 1.25),
    guide = "prism_offset_minor"
  ) +
  theme(
    axis.ticks.length = unit(10, "pt"),
    prism.ticks.length = unit(5, "pt"),
    axis.ticks = element_line(colour = "red"),
    axis.line = element_line(colour = "blue")
  )
}
