% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggecdf.R
\name{ggecdf}
\alias{ggecdf}
\title{Empirical cumulative density function}
\usage{
ggecdf(data, x, color = "black", palette = NULL, size = NULL,
  linetype = "solid", ggtheme = theme_classic2(), ...)
}
\arguments{
\item{data}{a data frame}

\item{x}{variable to be drawn.}

\item{color}{line and point color.}

\item{palette}{the color palette to be used for coloring or filling by
groups. Allowed values include "grey" for grey color palettes; brewer
palettes e.g. "RdBu", "Blues", ...; or custom color palette e.g. c("blue",
"red"); and scientific journal palettes from ggsci R package, e.g.: "npg", "aaas", "lancet", "jco",
"ucscgb", "uchicago", "simpsons" and "rickandmorty".}

\item{size}{line and point size.}

\item{linetype}{line type. See \code{\link{show_line_types}}.}

\item{ggtheme}{function, ggplot2 theme name. Default value is theme_pubr().
Allowed values include ggplot2 official themes: theme_gray(), theme_bw(),
theme_minimal(), theme_classic(), theme_void(), ....}

\item{...}{other arguments to be passed to
\code{\link[ggplot2]{stat_ecdf}} and \code{\link{ggpar}}.}
}
\description{
Empirical Cumulative Density Function (ECDF).
}
\details{
The plot can be easily customized using the function ggpar(). Read
  ?ggpar for changing: \itemize{ \item main title and axis labels: main,
  xlab, ylab \item axis limits: xlim, ylim (e.g.: ylim = c(0, 30)) \item axis
  scales: xscale, yscale (e.g.: yscale = "log2") \item color palettes:
  palette = "Dark2" or palette = c("gray", "blue", "red") \item legend title,
  labels and position: legend = "right" \item plot orientation : orientation
  = c("vertical", "horizontal", "reverse") }
}
\examples{
# Create some data format
set.seed(1234)
wdata = data.frame(
   sex = factor(rep(c("F", "M"), each=200)),
   weight = c(rnorm(200, 55), rnorm(200, 58)))

head(wdata, 4)

# Basic ECDF plot
ggecdf(wdata, x = "weight")

# Change colors and linetype by groups ("sex")
# Use custom palette
ggecdf(wdata, x = "weight",
   color = "sex", linetype = "sex",
   palette = c("#00AFBB", "#E7B800"))

}
\seealso{
\code{\link{ggpar}}
}

