% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_summary.R
\name{add_summary}
\alias{add_summary}
\alias{mean_se_}
\alias{mean_sd}
\alias{mean_ci}
\alias{mean_range}
\alias{median_iqr}
\alias{median_mad}
\alias{median_range}
\title{Add Summary Statistics onto a ggplot.}
\usage{
add_summary(p, fun = "mean_se", error.plot = "pointrange",
  color = "black", fill = "white", group = 1, width = NULL,
  shape = 19, size = 1, linetype = 1, show.legend = NA,
  ci = 0.95, data = NULL, position = position_dodge(0.8))

mean_se_(x, error.limit = "both")

mean_sd(x, error.limit = "both")

mean_ci(x, ci = 0.95, error.limit = "both")

mean_range(x, error.limit = "both")

median_iqr(x, error.limit = "both")

median_mad(x, error.limit = "both")

median_range(x, error.limit = "both")
}
\arguments{
\item{p}{a ggplot on which you want to add summary statistics.}

\item{fun}{a function that is given the complete data and should return a data
frame with variables ymin, y, and ymax. Allowed values are one of: "mean",
"mean_se", "mean_sd", "mean_ci", "mean_range", "median", "median_iqr",
"median_mad", "median_range".}

\item{error.plot}{plot type used to visualize error. Allowed values are one of
\code{c("pointrange", "linerange", "crossbar", "errorbar", "upper_errorbar",
"lower_errorbar", "upper_pointrange", "lower_pointrange", "upper_linerange",
"lower_linerange")}. Default value is "pointrange".}

\item{color}{point or outline color.}

\item{fill}{fill color. Used only whne \code{error.plot = "crossbar"}.}

\item{group}{grouping variable. Allowed values are 1 (for one group) or a
character vector specifying the name of the grouping variable. Used only for
adding statistical summary per group.}

\item{width}{numeric value between 0 and 1 specifying bar or box width.
Example width = 0.8. Used only when \code{error.plot} is one of
c("crossbar", "errorbar").}

\item{shape}{point shape. Allowed values can be displayed using the function
\code{\link{show_point_shapes}()}.}

\item{size}{numeric value in [0-1] specifying point and line size.}

\item{linetype}{line type.}

\item{show.legend}{logical. Should this layer be included in the legends? NA,
the default, includes if any aesthetics are mapped. \code{FALSE} never includes,
and TRUE always includes. It can also be a named logical vector to finely
select the aesthetics to display.}

\item{ci}{the percent range of the confidence interval (default is 0.95).}

\item{data}{a \code{data.frame} to be displayed. If \code{NULL}, the default,
the data is inherited from the plot data as specified in the call to
\link[ggplot2]{ggplot}.}

\item{position}{position adjustment, either as a string, or the result of a
call to a position adjustment function. Used to adjust position for multiple
groups.}

\item{x}{a numeric vector.}

\item{error.limit}{allowed values are one of ("both", "lower", "upper",
"none") specifying whether to plot the lower and/or the upper limits of
error interval.}
}
\description{
add summary statistics onto a ggplot.
}
\section{Functions}{
\itemize{
\item \code{add_summary}: add summary statistics onto a ggplot.

\item \code{mean_se_}: returns the \code{mean} and the error limits defined by the
\code{standard error}. We used the name \code{mean_se_}() to avoid masking \code{\link[ggplot2]{mean_se}}().

\item \code{mean_sd}: returns the \code{mean} and the error limits defined by the
\code{standard deviation}.

\item \code{mean_ci}: returns the \code{mean} and the error limits defined by the
\code{confidence interval}.

\item \code{mean_range}: returns the \code{mean} and the error limits defined by the
\code{range = max - min}.

\item \code{median_iqr}: returns the \code{median} and the error limits
defined by the \code{interquartile range}.

\item \code{median_mad}: returns the \code{median} and the error limits
defined by the \code{median absolute deviation}.

\item \code{median_range}: returns the \code{median} and the error limits
defined by the \code{range = max - min}.
}}

\examples{

# Basic violin plot
p <- ggviolin(ToothGrowth, x = "dose", y = "len", add = "none")
p

# Add median_iqr
add_summary(p, "mean_sd")


}
