% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_pval_ggplot.R
\name{add_pval}
\alias{add_pval}
\title{Add p-values to ggplot objects.}
\usage{
add_pval(ggplot_obj, pairs = list(c(1, 2), c(1, 3)), test = "wilcox.test",
  heights = NULL, barheight = NULL, testsize = 5, pval_text_adj = NULL,
  annotation = NULL, log = FALSE, pval_star = FALSE,
  fold_change = FALSE)
}
\arguments{
\item{ggplot_obj}{ggplot object}

\item{pairs}{a list pairs of comparison. Groups indicated by integer numbers counted from left to right. e.g. list(c(1, 2), c(2, 3))
will compare first group with second, second group with third}

\item{test}{character of statistical testing method. e.g. t.test, wilcox.test. Default wilcox.test}

\item{heights}{integer or vector of integers. The heights of the p-value/annotation. Default maximum value from the data}

\item{barheight}{tip bar height of the annotation. Default calculated by range_y / 20}

\item{testsize}{p-value/annotation text size}

\item{pval_text_adj}{distance of p-value/annotation from annotation bar. Default barheight/2}

\item{annotation}{text to annotate. If specified, statistical test will not be done}

\item{log}{whether y axis is log transformed. Default FALSE}

\item{pval_star}{whether transform pval numbers to stars}

\item{fold_change}{whether also compute and show fold changes. Default FALSE.}
}
\description{
Add p-values to ggplot objects.
}
\examples{
library(ggplot2)
library(ggpval)
data("PlantGrowth")
plt <- ggplot(PlantGrowth, aes(group, weight)) +
  geom_boxplot()
add_pval(plt, pairs = list(c(1, 3)), test='wilcox.test')


}
