% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale_edge_shape.R
\name{scale_edge_shape}
\alias{scale_edge_shape}
\alias{scale_edge_shape_discrete}
\alias{scale_edge_shape_continuous}
\alias{scale_edge_shape_manual}
\alias{scale_edge_shape_identity}
\title{Edge shape scales}
\usage{
scale_edge_shape(..., solid = TRUE)

scale_edge_shape_discrete(..., solid = TRUE)

scale_edge_shape_continuous(...)

scale_edge_shape_manual(..., values)

scale_edge_shape_identity(..., guide = "none")
}
\arguments{
\item{...}{Arguments passed on to \code{discrete_scale}
\describe{
  \item{palette}{A palette function that when called with a single integer
argument (the number of levels in the scale) returns the values that
they should take.}
  \item{breaks}{One of:
\itemize{
\item \code{NULL} for no breaks
\item \code{waiver()} for the default breaks computed by the
transformation object
\item A character vector of breaks
\item A function that takes the limits as input and returns breaks
as output
}}
  \item{limits}{A character vector that defines possible values of the scale
and their order.}
  \item{drop}{Should unused factor levels be omitted from the scale?
The default, \code{TRUE}, uses the levels that appear in the data;
\code{FALSE} uses all the levels in the factor.}
  \item{na.translate}{Unlike continuous scales, discrete scales can easily show
missing values, and do so by default. If you want to remove missing values
from a discrete scale, specify \code{na.translate = FALSE}.}
  \item{na.value}{If \code{na.translate = TRUE}, what value aesthetic
value should missing be displayed as? Does not apply to position scales
where \code{NA} is always placed at the far right.}
  \item{aesthetics}{The names of the aesthetics that this scale works with}
  \item{scale_name}{The name of the scale}
  \item{name}{The name of the scale. Used as the axis or legend title. If
\code{waiver()}, the default, the name of the scale is taken from the first
mapping used for that aesthetic. If \code{NULL}, the legend title will be
omitted.}
  \item{labels}{One of:
\itemize{
\item \code{NULL} for no labels
\item \code{waiver()} for the default labels computed by the
transformation object
\item A character vector giving labels (must be same length as \code{breaks})
\item A function that takes the breaks as input and returns labels
as output
}}
  \item{guide}{A function used to create a guide or its name. See
\code{\link[=guides]{guides()}} for more info.}
  \item{super}{The super class to use for the constructed scale}
}}

\item{solid}{Should the shapes be solid, \code{TRUE}, or hollow,
\code{FALSE}?}

\item{values}{a set of aesthetic values to map data values to. If this
is a named vector, then the values will be matched based on the names.
If unnamed, values will be matched in order (usually alphabetical) with
the limits of the scale. Any data values that don't match will be
given \code{na.value}.}

\item{guide}{Guide to use for this scale.}
}
\value{
A ggproto object inheriting from \code{Scale}
}
\description{
This set of scales defines new shape scales for edge geoms equivalent to the
ones already defined by ggplot2. See \code{\link[ggplot2:scale_shape]{ggplot2::scale_shape()}} for
more information. The different geoms will know whether to use edge scales or
the standard scales so it is not necessary to write \code{edge_shape} in
the call to the geom - just use \code{shape}.
}
\seealso{
Other scale_edge_*: \code{\link{scale_edge_alpha}},
  \code{\link{scale_edge_colour}},
  \code{\link{scale_edge_fill}},
  \code{\link{scale_edge_linetype}},
  \code{\link{scale_edge_size}},
  \code{\link{scale_edge_width}},
  \code{\link{scale_label_size}}
}
\concept{scale_edge_*}
