% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale_edge_width.R
\name{scale_edge_width}
\alias{scale_edge_width}
\alias{scale_edge_width_continuous}
\alias{scale_edge_width_discrete}
\alias{scale_edge_width_manual}
\alias{scale_edge_width_identity}
\title{Edge width scales}
\usage{
scale_edge_width_continuous(..., range = c(1, 6))

scale_edge_width(..., range = c(1, 6))

scale_edge_width_discrete(..., range = c(2, 6))

scale_edge_width_manual(..., values)

scale_edge_width_identity(..., guide = "none")
}
\arguments{
\item{...}{
  Arguments passed on to \code{\link[ggplot2:continuous_scale]{continuous_scale}}
  \describe{
    \item{\code{minor_breaks}}{One of:
\itemize{
\item \code{NULL} for no minor breaks
\item \code{waiver()} for the default breaks (one minor break between
each major break)
\item A numeric vector of positions
\item A function that given the limits returns a vector of minor breaks. Also
accepts rlang \link[rlang:as_function]{lambda} function notation.
}}
    \item{\code{oob}}{One of:
\itemize{
\item Function that handles limits outside of the scale limits
(out of bounds). Also accepts rlang \link[rlang:as_function]{lambda}
function notation.
\item The default (\code{\link[scales:oob]{scales::censor()}}) replaces out of
bounds values with \code{NA}.
\item \code{\link[scales:oob]{scales::squish()}} for squishing out of bounds values into range.
\item \code{\link[scales:oob]{scales::squish_infinite()}} for squishing infinite values into range.
}}
    \item{\code{na.value}}{Missing values will be replaced with this value.}
    \item{\code{expand}}{For position scales, a vector of range expansion constants used to add some
padding around the data to ensure that they are placed some distance
away from the axes. Use the convenience function \code{\link[ggplot2:expansion]{expansion()}}
to generate the values for the \code{expand} argument. The defaults are to
expand the scale by 5\% on each side for continuous variables, and by
0.6 units on each side for discrete variables.}
    \item{\code{position}}{For position scales, The position of the axis.
\code{left} or \code{right} for y axes, \code{top} or \code{bottom} for x axes.}
    \item{\code{super}}{The super class to use for the constructed scale}
  }}

\item{range}{a numeric vector of length 2 that specifies the minimum and
maximum size of the plotting symbol after transformation.}

\item{values}{a set of aesthetic values to map data values to. The values
will be matched in order (usually alphabetical) with the limits of the
scale, or with \code{breaks} if provided. If this is a named vector, then the
values will be matched based on the names instead. Data values that don't
match will be given \code{na.value}.}

\item{guide}{A function used to create a guide or its name. See
\code{\link[ggplot2:guides]{guides()}} for more information.}
}
\value{
A ggproto object inheriting from \code{Scale}
}
\description{
This set of scales defines width scales for edge geoms. Of all the new edge
scales defined in ggraph, this is the only one not having an equivalent in
ggplot2. In essence it mimics the use of size in
\code{\link[ggplot2:geom_path]{ggplot2::geom_line()}} and related. As almost all edge
representations are lines of some sort, edge_width will be used much more
often than edge_size. It is not necessary to spell out that it is an edge
scale as the geom knows if it is drawing an edge. Just write \code{width} and
not \code{edge_width} in the call to geoms.
}
\seealso{
Other scale_edge_*: 
\code{\link{scale_edge_alpha}()},
\code{\link{scale_edge_colour}},
\code{\link{scale_edge_fill}},
\code{\link{scale_edge_linetype}()},
\code{\link{scale_edge_shape}()},
\code{\link{scale_edge_size}()},
\code{\link{scale_label_size}()}
}
\concept{scale_edge_*}
