% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layout_metro.R
\name{layout_tbl_graph_metro}
\alias{layout_tbl_graph_metro}
\title{Place nodes according to the standard design of metro maps}
\usage{
layout_tbl_graph_metro(
  graph,
  x,
  y,
  length = 2,
  grid_space = 0.0025,
  optimization_weights = NULL,
  max_movement = 5,
  circular = FALSE
)
}
\arguments{
\item{graph}{A tbl_graph object}

\item{x, y}{The start location of the nodes}

\item{length}{Desired multiple of grid point spacing. (\code{length * grid_space}
determines desired edge length)}

\item{grid_space}{The distance between consecitive grid points}

\item{optimization_weights}{The relative weight to be placed on the 5
criteria during optimization as a numeric vector of length 4. The criteria
are:
\itemize{
\item \verb{Angular Resolution Criterion}: The angles of incident edges at each
station should be maximized, because if there is only a small angle between
any two adjacent edges, then it can become difficult to distinguish between
them.
\item \verb{Edge Length Criterion}: The edge lengths across the whole map should be
approximately equal to ensure regular spacing between stations. It is based
on the preferred multiple, l, of the grid spacing, g. The purpose of the
criterion is to penalize edges that are longer than or shorter than lg.
\item \verb{Balanced Edge Length Criterion}: The length of edges incident to a
particular station should be similar.
\item \verb{Line Straightness Criterion}: (not yet implemented) Edges that form part
of a line should, where possible, be co-linear either side of each station
that the line passes through.
\item \verb{Octiinearity Criterion}: Each edge should be drawn horizontally,
vertically, or diagonally at 45 degree, so we penalize edges that are not
at a desired angle.
If \code{NULL} all criteria are given equal weight.
}}

\item{max_movement}{Number of grid points a station can move away rom its
original position}

\item{circular}{ignored}
}
\value{
A data.frame with the columns \code{x}, \code{y}, \code{circular} as
well as any information stored as node variables in the tbl_graph object.
}
\description{
This layouttries to optimise the placement of nodes so that they adhere to
the classic look of metro maps. As such it optimizes on the distribution of
incident edge angles, conformity of edge length, and edge angles in multiples
of 45 degrees. As it works as a refinement of an already existing layout
(the physical location of metro stations) it requires an a priori node
location. Due to it's purpose it probably works best with planar graphs.
}
\references{
Stott, J., Rodgers, P., Martinez-Ovando, J. C., and Walker, S. G. (2011).
\emph{Automatic metro map layout using multicriteria optimization} In IEEE Trans
Vis Comput Graph 17(1) pp. 101-114. https://doi.org/10.1109/tvcg.2010.24
}
\seealso{
Other layout_tbl_graph_*: 
\code{\link{layout_tbl_graph_auto}()},
\code{\link{layout_tbl_graph_backbone}()},
\code{\link{layout_tbl_graph_cactustree}()},
\code{\link{layout_tbl_graph_centrality}()},
\code{\link{layout_tbl_graph_circlepack}()},
\code{\link{layout_tbl_graph_dendrogram}()},
\code{\link{layout_tbl_graph_eigen}()},
\code{\link{layout_tbl_graph_fabric}()},
\code{\link{layout_tbl_graph_focus}()},
\code{\link{layout_tbl_graph_hive}()},
\code{\link{layout_tbl_graph_htree}()},
\code{\link{layout_tbl_graph_igraph}()},
\code{\link{layout_tbl_graph_linear}()},
\code{\link{layout_tbl_graph_manual}()},
\code{\link{layout_tbl_graph_matrix}()},
\code{\link{layout_tbl_graph_partition}()},
\code{\link{layout_tbl_graph_pmds}()},
\code{\link{layout_tbl_graph_sf}()},
\code{\link{layout_tbl_graph_stress}()},
\code{\link{layout_tbl_graph_treemap}()},
\code{\link{layout_tbl_graph_unrooted}()}
}
\author{
The underlying algorithm is implemented in the graphlayouts package
by David Schoch
}
\concept{layout_tbl_graph_*}
