% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_coloring.R
\name{map_coloring}
\alias{map_coloring}
\title{Produce a Map Coloring}
\usage{
map_coloring(shp, min_coloring = TRUE)
}
\arguments{
\item{shp}{an \code{sf} object}

\item{min_coloring}{if \code{TRUE}, try to minimize the number of colors used}
}
\value{
an integer vector of the same length as \code{shp}, corresponding to the
coloring.
}
\description{
Finds colors for every element of a shapefile so that adjacent elements don't
have the same color.
}
\examples{
data(oregon)
or_short = oregon[30:50, ]
map_coloring(or_short)

library(ggplot2)
ggplot(or_short, aes(fill = map_coloring(or_short))) +
    geom_sf() +
    theme_map()

}
