% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom-label-repel.R, R/geom-text-repel.R
\name{geom_label_repel}
\alias{geom_label_repel}
\alias{geom_text_repel}
\title{Repulsive textual annotations.}
\usage{
geom_label_repel(mapping = NULL, data = NULL, stat = "identity",
  position = "identity", parse = FALSE, ..., box.padding = 0.25,
  label.padding = 0.25, point.padding = 1e-06, label.r = 0.15,
  label.size = 0.25, segment.colour = NULL, segment.color = NULL,
  segment.size = 0.5, segment.alpha = NULL, min.segment.length = 0.5,
  arrow = NULL, force = 1, max.iter = 2000, nudge_x = 0, nudge_y = 0,
  xlim = c(NA, NA), ylim = c(NA, NA), na.rm = FALSE, show.legend = NA,
  direction = c("both", "y", "x"), seed = NA, inherit.aes = TRUE)

geom_text_repel(mapping = NULL, data = NULL, stat = "identity",
  position = "identity", parse = FALSE, ..., box.padding = 0.25,
  point.padding = 1e-06, segment.colour = NULL, segment.color = NULL,
  segment.size = 0.5, segment.alpha = NULL, min.segment.length = 0.5,
  arrow = NULL, force = 1, max.iter = 2000, nudge_x = 0, nudge_y = 0,
  xlim = c(NA, NA), ylim = c(NA, NA), na.rm = FALSE, show.legend = NA,
  direction = c("both", "y", "x"), seed = NA, inherit.aes = TRUE)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2]{aes}} or
\code{\link[ggplot2]{aes_}}. If specified and \code{inherit.aes = TRUE} (the
default), is combined with the default mapping at the top level of the
plot. You only need to supply \code{mapping} if there isn't a mapping
defined for the plot.}

\item{data}{A data frame. If specified, overrides the default data frame
defined at the top level of the plot.}

\item{stat}{The statistical transformation to use on the data for this
layer, as a string.}

\item{position}{Position adjustment, either as a string, or the result of
a call to a position adjustment function.}

\item{parse}{If TRUE, the labels will be parsed into expressions and
displayed as described in ?plotmath}

\item{...}{other arguments passed on to \code{\link[ggplot2]{layer}}. There are
  three types of arguments you can use here:

  \itemize{
    \item Aesthetics: to set an aesthetic to a fixed value, like
       \code{colour = "red"} or \code{size = 3}.
    \item Other arguments to the layer, for example you override the
      default \code{stat} associated with the layer.
    \item Other arguments passed on to the stat.
  }}

\item{box.padding}{Amount of padding around bounding box, as unit or number.
Defaults to 0.25. (Default unit is lines, but other units can be specified
by passing \code{unit(x, "units")}).}

\item{label.padding}{Amount of padding around label, as unit or number.
Defaults to 0.25. (Default unit is lines, but other units can be specified
by passing \code{unit(x, "units")}).}

\item{point.padding}{Amount of padding around labeled point, as unit or
number. Defaults to 0. (Default unit is lines, but other units can be
specified by passing \code{unit(x, "units")}).}

\item{label.r}{Radius of rounded corners, as unit or number. Defaults
to 0.15. (Default unit is lines, but other units can be specified by
passing \code{unit(x, "units")}).}

\item{label.size}{Size of label border, in mm.}

\item{segment.colour, segment.color}{Colour of the line segment. Defaults to the same colour
as the text. In the unlikely event you specify both US and UK spellings of colour, the
US spelling will take precedence.}

\item{segment.size}{Width of line segment connecting the data point to
the text label, in mm.}

\item{segment.alpha}{Transparency of the line segment. Defaults to the same
transparency as the text.}

\item{min.segment.length}{Skip drawing segments shorter than this, as unit or
number. Defaults to 0.5. (Default unit is lines, but other units can be
specified by passing \code{unit(x, "units")}).}

\item{arrow}{specification for arrow heads, as created by \code{\link[grid]{arrow}}}

\item{force}{Force of repulsion between overlapping text labels. Defaults
to 1.}

\item{max.iter}{Maximum number of iterations to try to resolve overlaps.
Defaults to 2000.}

\item{nudge_x, nudge_y}{Horizontal and vertical adjustments to nudge the
starting position of each text label.}

\item{xlim, ylim}{Limits for the x and y axes. Text labels will be constrained
to these limits. By default, text labels are constrained to the entire plot
area.}

\item{na.rm}{If \code{FALSE} (the default), removes missing values with
a warning.  If \code{TRUE} silently removes missing values.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.}

\item{direction}{"both", "x", or "y" -- direction in which to adjust position of labels}

\item{seed}{Random seed passed to \code{\link[base]{set.seed}}. Defaults to
\code{NA}, which means that \code{set.seed} will not be called.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2]{borders}}.}
}
\description{
\code{geom_text_repel} adds text directly to the plot.
\code{geom_label_repel} draws a rectangle underneath the text, making it
easier to read. The text labels repel away from each other and away from
the data points.
}
\details{
These geoms are based on \code{\link[ggplot2]{geom_text}} and
\code{\link[ggplot2]{geom_label}}. See the documentation for those
functions for more details. Differences from those functions are noted
here.

Text labels have height and width, but they are physical units, not data
units. The amount of space they occupy on that plot is not constant in data
units: when you resize a plot, labels stay the same size, but the size of
the axes changes. The text labels are repositioned after resizing a plot.
}
\section{\code{geom_label_repel}}{

Currently \code{geom_label_repel} does not support the \code{rot} argument
and is considerably slower than \code{geom_text_repel}. The \code{fill}
aesthetic controls the background colour of the label.
}

\section{Alignment with \code{hjust} or \code{vjust}}{

The arguments \code{hjust} and \code{vjust} are supported, but they only
control the initial positioning, so repulsive forces may disrupt alignment.
Alignment with \code{hjust} will be preserved if labels only move up and down
by using \code{direction="y"}. For \code{vjust}, use \code{direction="x"}.
}

\examples{

p <- ggplot(mtcars,
  aes(wt, mpg, label = rownames(mtcars), colour = factor(cyl))) +
  geom_point()

# Avoid overlaps by repelling text labels
p + geom_text_repel()
# Labels with background
p + geom_label_repel()

\dontrun{
p + geom_text_repel(family = "Times New Roman",
  box.padding = 0.5)

# Add aesthetic mappings
p + geom_text_repel(aes(alpha=wt, size=mpg))
p + geom_label_repel(aes(fill=factor(cyl)), colour="white", segment.colour="black")

# Draw all line segments
p + geom_text_repel(min.segment.length = 0)

# Omit short line segments (default behavior)
p + geom_text_repel(min.segment.length = 0.5)

# Omit all line segments
p + geom_text_repel(segment.colour = NA)

# Repel just the labels and totally ignore the data points
p + geom_text_repel(point.padding = NA)

# Hide some of the labels, but repel from all data points
mtcars$label <- rownames(mtcars)
mtcars$label[1:15] <- ""
p + geom_text_repel(data = mtcars, aes(wt, mpg, label = label))

# Nudge the starting positions
p + geom_text_repel(nudge_x = ifelse(mtcars$cyl == 6, 1, 0),
                    nudge_y = ifelse(mtcars$cyl == 6, 8, 0))

# Change the text size
p + geom_text_repel(aes(size = wt))
# Scale height of text, rather than sqrt(height)
p + geom_text_repel(aes(size = wt)) + scale_radius(range = c(3,6))

# You can display expressions by setting parse = TRUE.  The
# details of the display are described in ?plotmath, but note that
# geom_text_repel uses strings, not expressions.
p + geom_text_repel(aes(label = paste(wt, "^(", cyl, ")", sep = "")),
  parse = TRUE)

# Add a text annotation
p +
  geom_text_repel() +
  annotate(
    "text", label = "plot mpg vs. wt",
    x = 2, y = 15, size = 8, colour = "red"
  )

# Add arrows
p +
  geom_point(colour = "red") +
  geom_text_repel(
    arrow = arrow(length = unit(0.02, "npc")),
    box.padding = 1
  )

}
}
