% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pruneped.R
\name{pruneped}
\alias{pruneped}
\title{Pedigree pruning}
\usage{
pruneped(ped, pheno, mode)
}
\arguments{
\item{ped}{: \code{data.frame} with integer columns corresponding to ID, SIRE, DAM. Missing value is 0.}

\item{pheno}{: Vector of phenotyped individuals}

\item{mode}{: \code{strict} or \code{loose}}
}
\value{
newped : Pruned pedigree \code{data.frame}
}
\description{
Pruning pedigree in two different modes (strict, loose)
}
\details{
In strict pruning, individuals without progeny and phenotype are recursively deleted from the pedigree, and then individuals without known parent and without progeny (if any) are deleted. Therefore, all uninfluential individuals are deleted. The downside is that individuals without phenotype or phenotyped progeny cannot receive any genetic merit based on the information from their phenotyped relatives.
In loose pruning, the pedigree is upward extracted for phenotyped individuals to thier founders, and then the pedigree is downward extracted from the founders.
}
\examples{
ped = data.frame(ID=1:7, SIRE=c(0,0,1,3,1,4,0), DAM=c(0,0,2,2,2,5,0))
pheno = c(1,4)
pruneped(ped, pheno, mode="strict")
pruneped(ped, pheno, mode="loose")

}
