% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smgsped.R
\name{smgsped}
\alias{smgsped}
\title{Sire-maternal grandsire (S-MGS) pedigree}
\usage{
smgsped(ped, pheno)
}
\arguments{
\item{ped}{: \code{data.frame} with integer columns corresponding to ID, SIRE, DAM. Missing value is 0.}

\item{pheno}{: Vector of phenotyped individuals}
}
\value{
S-MGS pedigree \code{data.frame}
}
\description{
Extract sire-maternal grandsire (S-MGS) pedigree from a sire-dam pedigree. Sire and MGS information is extracted for sires of phenotyped individuals.
}
\examples{
ped = data.frame(ID=1:10, SIRE=c(0,0,1,2,0,5,4,4,0,8), DAM=c(0,0,0,3,3,0,6,6,6,0))
smgsped(ped, 7:10)

}
