% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discrete-aaas.R
\name{pal_aaas}
\alias{pal_aaas}
\title{AAAS journal color palettes}
\usage{
pal_aaas(palette = c("default"), alpha = 1)
}
\arguments{
\item{palette}{Palette type.
Currently there is one available option: \code{"default"}
(10-color palette inspired by \emph{Science}).}

\item{alpha}{Transparency level, a real number in (0, 1].
See \code{alpha} in \code{\link[grDevices:rgb]{grDevices::rgb()}} for details.}
}
\description{
Color palettes inspired by plots in journals published by
American Association for the Advancement of Science (AAAS),
such as \emph{Science} and \emph{Science Translational Medicine}.
}
\examples{
library("scales")
show_col(pal_aaas("default")(10))
show_col(pal_aaas("default", alpha = 0.6)(10))
}
\author{
Nan Xiao | \email{me@nanx.me} | \url{https://nanx.me}
}
