% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draw_loops.R
\name{draw_loops}
\alias{draw_loops}
\title{Draw self-loop arrows from a self-loop arrow CSV file (from ggsem Shiny app) on a ggplot object}
\usage{
draw_loops(p, loops_data, zoom_level = 1)
}
\arguments{
\item{p}{A ggplot object}

\item{loops_data}{An object that stores the CSV file containing information about self-loop arrows from the ggsem shiny app.}

\item{zoom_level}{A numeric value to control the zoom level of the plot. Default is 1.}
}
\value{
A ggplot object is returned as the function's output.
}
\description{
This function adds self-loop arrows onto any ggplot output (including your own plots not created from the ggsem shiny app).
}
\examples{
library(ggplot2)

loops_data <- data.frame(
x_center = -5, y_center = 5, radius = 2, color = '#000000', width = 1,
alpha = 1, arrow_type = 'closed', arrow_size = 0.1, gap_size = 0.2,
loop_width = 1, loop_height = 20, orientation = 0,
two_way = FALSE, locked = FALSE
)

p <- ggplot(mtcars) + geom_point(aes(mpg, disp))

draw_loops(p, loops_data, zoom_level = 1.2)
}
