% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggside.R
\name{yside}
\alias{yside}
\title{The yside geometries}
\value{
geom_yside* return a YLayer object to be added to a ggplot
}
\description{
\code{yside} refers to the api of ggside. Any \code{geom_} with
\code{yside} will plot its respective geometry along the y-axis per
facet panel. The yside panel will plot to the right of the main
panel by default. This yside panel will always share the same scale
as it's main panel, but is expected to have a separate x-axis scaling.
}
\section{New Aesthetics}{


All \code{yside} Geometries have \code{yfill}, \code{ycolour}/\code{ycolor} available for
aesthetic mappings. These mappings behave exactly like the default
counterparts except that they are considered separate scales. All
\code{yside} geometries will use \code{yfill} over \code{fill}, but will default
to \code{fill} if \code{yfill} is not provided. The same goes for \code{ycolour} in
respects to \code{colour}. This comes in handy if you wish to map both \code{fill}
to one geometry as continuous, you can still map \code{yfill} for a separate
\code{yside} geometry without conflicts. See more information in
\code{vignette("ggside")}.

#' @section Exported Geometries:

The following are the \code{yside} variants of the \link{ggplot2} Geometries

\itemize{
\item \link{geom_ysidebar}
\item \link{geom_ysideboxplot}
\item \link{geom_ysidecol}
\item \link{geom_ysidedensity}
\item \link{geom_ysidefreqpoly}
\item \link{geom_ysidehistogram}
\item \link{geom_ysideline}
\item \link{geom_ysidepath}
\item \link{geom_ysidepoint}
\item \link{geom_ysidetext}
\item \link{geom_ysidetile}
\item \link{geom_ysideviolin}
}
}

\seealso{
\link{xside}
}
