% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genealogy.R
\name{plot_genealogy}
\alias{plot_genealogy}
\title{Plot an SMC or EnK genealogy from algorithm output.}
\usage{
plot_genealogy(
  output,
  parameter,
  dimension = 1,
  target = NULL,
  external_target = NULL,
  use_initial_points = TRUE,
  use_weights = TRUE,
  alpha_points = 0.1,
  alpha_lines = 0.1,
  axis_limits = NULL,
  vertical = TRUE,
  arrows = TRUE,
  default_title = FALSE
)
}
\arguments{
\item{output}{Output from the SMC or EnK algorithm.}

\item{parameter}{The parameter we wish to see the evolution of.}

\item{dimension}{(optional) The dimension of the parameter we wish to see the evolution of. (default is 1)}

\item{target}{(optional) The target to plot. (default is to use all targets)}

\item{external_target}{(optional) The external target to plot. (default is to use all external targets, or to ignore if the column is not present)}

\item{use_initial_points}{(optional) If target is not specified and this argument is TRUE, will add the initial unweighted proposed points to the output to be plotted. (default is TRUE)}

\item{use_weights}{(optional) If FALSE, will ignore particle weights in the line graph. If TRUE, will use the particle weights. (defaults to TRUE)}

\item{alpha_points}{(optional) The transparency of the points in the plot. (default=0.1)}

\item{alpha_lines}{(optional) The transparency of the lines in the plot. (default=0.1)}

\item{axis_limits}{(optional) Input of the form c(start,end), which specifies the ends of the parameter axis.}

\item{vertical}{(optional) If TRUE (default), plots a genealogy vertically. If FALSE, plots horizontally.}

\item{arrows}{(optional) If TRUE (default), includes arrowheads. If FALSE, arrowheads are omitted.}

\item{default_title}{(optional) If TRUE, will provide a default title for the figure. If FALSE, no title is used. (defaults to FALSE)}
}
\value{
A particle genealogy in a ggplot figure.
}
\description{
Plot an SMC or EnK genealogy from algorithm output.
}
