% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-filter-spct.r
\name{plot.reflector_spct}
\alias{plot.reflector_spct}
\title{Plot a reflector spectrum, especialization of generic plot function}
\usage{
\method{plot}{reflector_spct}(x, ...,
  w.band = getOption("photobiology.plot.bands", default = list(UVC(), UVB(),
  UVA(), PAR())), range = NULL,
  plot.qty = getOption("photobiology.reflector.qty", default = "reflectance"),
  pc.out = FALSE, label.qty = "average",
  annotations = getOption("photobiology.plot.annotations", default =
  c("boxes", "labels", "summaries", "colour.guide", "peaks")))
}
\arguments{
\item{x}{a reflector_spct object}

\item{...}{other arguments passed along, such as \code{label.qty}}

\item{w.band}{a single waveband object or a list of waveband objects}

\item{range}{an R object on which range() returns a vector of length 2, with
min annd max wavelengths (nm)}

\item{plot.qty}{character string (currently ignored)}

\item{pc.out}{logical, if TRUE use percents instead of fraction of one}

\item{label.qty}{character string giving the type of summary quantity to use
for labels}

\item{annotations}{a character vector}
}
\value{
a \code{ggplot} object.
}
\description{
This function returns a ggplot object with an annotated plot of a
reflector_spct object.
}
\note{
Note that scales are expanded so as to make space for the annotations.
  The object returned is a ggplot objects, and can be further manipulated.
}
\examples{

library(photobiology)
plot(as.reflector_spct(white_body.spct))

}
\seealso{
Other plot functions: \code{\link{plot.cps_spct}},
  \code{\link{plot.filter_spct}},
  \code{\link{plot.object_spct}},
  \code{\link{plot.raw_spct}},
  \code{\link{plot.response_spct}},
  \code{\link{plot.source_spct}},
  \code{\link{plot.waveband}}
}
\keyword{hplot}

