% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers_ggbetween_anova_subtitles.R
\name{subtitle_anova_nonparametric}
\alias{subtitle_anova_nonparametric}
\title{Making text subtitle for nonparametric ANOVA.}
\usage{
subtitle_anova_nonparametric(data, x, y, paired = FALSE,
  conf.type = "norm", conf.level = 0.95, k = 2, nboot = 100,
  stat.title = NULL, messages = TRUE, ...)
}
\arguments{
\item{data}{A dataframe (or a tibble) from which variables specified are to
be taken. A matrix or tables will \strong{not} be accepted.}

\item{x}{The grouping variable from the dataframe \code{data}.}

\item{y}{The response (a.k.a. outcome or dependent) variable from the
dataframe \code{data}.}

\item{paired}{Logical that decides whether the design is repeated
measures/within-subjects (in which case one-way Friedman Rank Sum Test will
be carried out) or between-subjects (in which case one-way Kruskal–Wallis H
test will be carried out). The default is \code{FALSE}.}

\item{conf.type}{A vector of character strings representing the type of
intervals required. The value should be any subset of the values \code{"norm"},
\code{"basic"}, \code{"perc"}, \code{"bca"}. For more, see \code{?boot::boot.ci}.}

\item{conf.level}{Scalar between 0 and 1. If unspecified, the defaults return
\code{95\%} lower and upper confidence intervals (\code{0.95}).}

\item{k}{Number of digits after decimal point (should be an integer)
(Default: \code{k = 2}).}

\item{nboot}{Number of bootstrap samples for computing confidence interval
for the effect size (Default: \code{100}).}

\item{stat.title}{A character describing the test being run, which will be
added as a prefix in the subtitle. The default is \code{NULL}. An example of a
\code{stat.title} argument will be something like \code{"Student's t-test: "}.}

\item{messages}{Decides whether messages references, notes, and warnings are
to be displayed (Default: \code{TRUE}).}

\item{...}{Additional arguments.}
}
\description{
For paired designs, the effect size is Kendall's coefficient of
concordance (\emph{W}), while for between-subjects designs, the effect size is
H-statistic based eta-squared.
}
\examples{
# setup
set.seed(123)
library(ggstatsplot)

# -------------- within-subjects design --------------------------------

library(jmv)
data("bugs", package = "jmv")

# converting to long format
data_bugs <- bugs \%>\%
  tibble::as_tibble(.) \%>\%
  tidyr::gather(., key, value, LDLF:HDHF)

# creating the subtitle
ggstatsplot::subtitle_anova_nonparametric(
  data = data_bugs,
  x = key,
  y = value,
  paired = TRUE,
  k = 2
)

# -------------- between-subjects design --------------------------------

ggstatsplot::subtitle_anova_nonparametric(
  data = ggplot2::msleep,
  x = vore,
  y = sleep_rem,
  paired = FALSE,
  conf.level = 0.99
)
}
\author{
Indrajeet Patil
}
