% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggcoefstats.R
\name{ggcoefstats}
\alias{ggcoefstats}
\title{Model coefficients for fitted models with the model summary as a
caption.}
\usage{
ggcoefstats(x, output = "plot", effects = "fixed", scales = NULL,
  ran.prefix = NULL, conf.method = "Wald", coefficient.type = "beta",
  effsize = "eta", nboot = 1000, point.color = "blue", point.size = 3,
  point.shape = 16, conf.int = TRUE, conf.level = 0.95, k = 3,
  k.caption.summary = 0, exclude.intercept = TRUE, exponentiate = FALSE,
  errorbar.color = "black", errorbar.height = 0,
  errorbar.linetype = "solid", errorbar.size = 0.5, vline = TRUE,
  vline.color = "black", vline.linetype = "dashed", vline.size = 1,
  sort = "none", xlab = "regression coefficient", ylab = "term",
  title = NULL, subtitle = NULL, stats.labels = TRUE,
  caption.summary = TRUE, stats.label.size = 3,
  stats.label.fontface = "bold", stats.label.color = "black",
  label.r = 0.15, label.size = 0.25, label.box.padding = 1,
  label.label.padding = 0.25, label.point.padding = 0.5,
  label.segment.color = "grey50", label.segment.size = 0.5,
  label.segment.alpha = NULL, label.min.segment.length = 0.5,
  label.force = 1, label.max.iter = 2000, label.nudge.x = 0,
  label.nudge.y = 0, label.xlim = c(NA, NA), label.ylim = c(NA, NA),
  label.direction = "y", ggtheme = ggplot2::theme_bw(), ...)
}
\arguments{
\item{x}{A model object to be tidied with \code{broom::tidy}.}

\item{output}{Character describing the expected output from this function:
\code{"plot"} (visualization of regression coefficients) or \code{"tidy"} (tidy
dataframe of results from \code{broom::tidy}) or \code{"glance"} (object from
\code{broom::glance}) or \code{"augment"} (object from \code{broom::augment}).}

\item{effects}{In case the object is of class \code{merMod}
(\code{lmerMod}, \code{glmerMod}, \code{nlmerMod}), these arguments determine which
effects are to be displayed. By default, only the \code{"fixed"} effects will be
shown. Other option is \code{"ran_pars"}.}

\item{scales}{scales on which to report the variables: for random effects, the choices are \sQuote{"sdcor"} (standard deviations and correlations: the default if \code{scales} is \code{NULL}) or \sQuote{"vcov"} (variances and covariances). \code{NA} means no transformation, appropriate e.g. for fixed effects; inverse-link transformations (exponentiation
or logistic) are not yet implemented, but may be in the future.}

\item{ran.prefix}{A length-2 character vector specifying the strings to use
as prefixes for self- (variance/standard deviation) and cross- (covariance
/correlation) random effects terms.}

\item{conf.method}{method for computing confidence intervals (see \code{lme4::confint.merMod})}

\item{coefficient.type}{For ordinal regression models, which parameters to
display in the plot. By default only \code{"beta"} (a vector of regression
parameters) parameters will be show. Other options are \code{"alpha"} (a vector
of threshold parameters) or \code{"both"}.}

\item{effsize}{Character describing the effect size to be displayed: \code{"eta"}
(default) or \code{"omega"}.}

\item{nboot}{Number of bootstrap samples for confidence intervals for partial
eta-squared and omega-squared (Default: \code{1000}).}

\item{point.color}{Character describing color for the point (Default:
\code{"blue"}).}

\item{point.size}{Numeric specifying size for the point (Default: \code{3}).}

\item{point.shape}{Numeric specifying shape to draw the points (Default: \code{16}
(\strong{a dot})).}

\item{conf.int}{Logical. Decides whether to display confidence intervals as
error bars (Default: \code{TRUE}).}

\item{conf.level}{Numeric deciding level of confidence intervals (Default:
\code{0.95}).}

\item{k}{Number of decimal places expected for results displayed in labels.}

\item{k.caption.summary}{Number of decimal places expected for results
displayed in captions.}

\item{exclude.intercept}{Logical that decides whether the intercept should be
excluded from the plot (Default: \code{TRUE}).}

\item{exponentiate}{If \code{TRUE}, the x-axis will be logarithmic (Default:
\code{FALSE}).}

\item{errorbar.color}{Character deciding color of the error bars (Default:
\code{"black"}).}

\item{errorbar.height}{Numeric specifying the height of the error bars
(Default: \code{0}).}

\item{errorbar.linetype}{Line type of the error bars (Default: \code{"solid"}).}

\item{errorbar.size}{Numeric specifying the size of the error bars (Default:
\code{0.5}).}

\item{vline}{Decides whether to display a vertical line (Default: \code{"TRUE"}).}

\item{vline.color}{Character specifying color of the vertical line (Default:
\code{"black"}).}

\item{vline.linetype}{Character specifying line type of the vertical line
(Default: \code{"dashed"}).}

\item{vline.size}{Numeric specifying the size of the vertical line (Default:
\code{1}).}

\item{sort}{\code{"none"} (default) do not sort, \code{"ascending"} sort by increasing
coefficient value, or \code{"descending"} sort by decreasing coefficient value.}

\item{xlab}{Label for \code{x} axis variable (Default: \code{"estimate"}).}

\item{ylab}{Label for \code{y} axis variable (Default: \code{"term"}).}

\item{title}{The text for the plot title.}

\item{subtitle}{The text for the plot subtitle.}

\item{stats.labels}{Logical. Decides whether the statistic and p-values for
each coefficient are to be attached to each dot as a text label using
\code{ggrepel} (Default: \code{TRUE}).}

\item{caption.summary}{Logical. Decides whether the model summary should be
displayed as a cation to the plot (Default: \code{TRUE}). Color of the line
segment. Defaults to the same color as the text.}

\item{stats.label.size, stats.label.fontface, stats.label.color}{Aesthetics for
the labels. Defaults: \code{3}, \code{"bold"},\code{"black"}, resp.}

\item{label.r, }{Radius of rounded corners, as unit or number. Defaults to
\code{0.15}. (Default unit is lines).}

\item{label.size}{Size of label border, in mm. Defaults to \code{0.25}.}

\item{label.box.padding}{Amount of padding around bounding box, as number.
Defaults to \code{1}. (Default unit is lines).}

\item{label.label.padding}{Amount of padding around label, as number.
Defaults to \code{0.25}. (Default unit is lines).}

\item{label.point.padding}{Amount of padding around labeled point, as
number. Defaults to \code{0}. (Default unit is lines).}

\item{label.segment.color}{Color of the line segment (Default: \code{"grey50"}).}

\item{label.segment.size}{Width of line segment connecting the data point to
the text label, in mm. Defaults to \code{0.5}.}

\item{label.segment.alpha}{Transparency of the line segment. Defaults to the
same transparency as the text.}

\item{label.min.segment.length}{Skip drawing segments shorter than this.
Defaults to \code{0.5}. (Default unit is lines).}

\item{label.force}{Force of repulsion between overlapping text labels.
Defaults to \code{1}.}

\item{label.max.iter}{Maximum number of iterations to try to resolve
overlaps. Defaults to \code{2000}.}

\item{label.nudge.x, label.nudge.y}{Horizontal and vertical adjustments to
nudge the starting position of each text label. Defaults to \code{0}.}

\item{label.xlim, label.ylim}{Limits for the x and y axes. Text labels will be
constrained to these limits. By default, text labels are constrained to the
entire plot area. Defaults to \code{c(NA, NA)}.}

\item{label.direction}{Character (\code{"both"}, \code{"x"}, or \code{"y"}) -- direction in
which to adjust position of labels (Default: \code{"y"}).}

\item{ggtheme}{A function, \code{ggplot2} theme name. Default value is
\code{ggplot2::theme_bw()}. Allowed values are the official \code{ggplot2} themes,
including \code{theme_bw()}, \code{theme_minimal()}, \code{theme_classic()},
\code{theme_void()}, etc.}

\item{\dots}{Extra arguments to pass to \code{\link[broom]{tidy}}.}
}
\value{
Plot with the regression coefficients' point estimates as dots with
confidence interval whiskers.
}
\description{
Model coefficients for fitted models with the model summary as a
caption.
}
\examples{

set.seed(123)
ggcoefstats(x = lm(formula = mpg ~ cyl * am, data = mtcars))

}
\author{
Indrajeet Patil
}
