% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers_stats.R
\name{signif_column}
\alias{signif_column}
\title{Creating a new character type column with significance labels}
\usage{
signif_column(data = NULL, p)
}
\arguments{
\item{data}{Data frame from which variables specified are preferentially to
be taken.}

\item{p}{The column containing p-values.}
}
\value{
Returns the originally entered object (either a vector or a
dataframe) in tibble format with an additional column corresponding to
statistical significance.
}
\description{
This function will add a new column to a dataframe containing
\emph{p}-values
}
\examples{

# vector as input
signif_column(p = c(0.05, 0.1, 1, 0.00001, 0.001, 0.01))

# dataframe as input
# preparing a newdataframe
df <- tibble(
  x = 1:5,
  y = 1,
  p.value = c(0.1, 0.5, 0.00001, 0.05, 0.01)
)

signif_column(data = df, p = p.value)

# numbers entered as characters are also tolerated
signif_column(p = c("1", "0.1", "0.0002", "0.03", "0.65"))
}
\seealso{
Other helper_stats: \code{\link{check_outlier}},
  \code{\link{grouped_proptest}}, \code{\link{untable}}
}
\author{
Indrajeet Patil
}
\concept{helper_stats}
