% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers_bf_tests.R
\name{bf_corr_test}
\alias{bf_corr_test}
\title{Bayesian correlation test.}
\usage{
bf_corr_test(data, x, y, bf.prior = 0.707, caption = NULL,
  output = "caption", k = 2)
}
\arguments{
\item{data}{Dataframe from which variables are to be taken.}

\item{x}{The column in \code{data} containing the explanatory variable to be
plotted on the x axis. Can be entered either as
a character string (e.g., \code{"x"}) or as a bare expression (e.g, \code{x}).}

\item{y}{The column in \code{data} containing the response (outcome) variable to
be plotted on the y axis. Can be entered either as
a character string (e.g., \code{"y"}) or as a bare expression (e.g, \code{y}).}

\item{bf.prior}{A number between 0.5 and 2 (default \code{0.707}), the prior width
to use in calculating Bayes factors.}

\item{caption}{The text for the plot caption.}

\item{output}{Can either be \code{"caption"} (which will contain text for evidence
in favor of null)  or \code{"results"} (which will return the dataframe with
results).}

\item{k}{Number of decimal places expected for results.}
}
\description{
Bayesian correlation test.
}
\examples{

# for reproducibility
set.seed(123)

# to get caption (default)
bf_corr_test(
  data = anscombe,
  x = x1,
  y = y4,
  bf.prior = 1
)

# to see results
bf_corr_test(
  data = anscombe,
  x = x1,
  y = y4,
  bf.prior = 0.8,
  output = "results"
)
}
\seealso{
\code{\link{bf_contingency_tab}}, \code{\link{bf_oneway_anova}},
\code{\link{bf_two_sample_ttest}}
}
\author{
Indrajeet Patil
}
