% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grouped_gghistostats.R
\name{grouped_gghistostats}
\alias{grouped_gghistostats}
\title{Grouped histograms for distribution of a numeric variable}
\usage{
grouped_gghistostats(
  data,
  x,
  grouping.var,
  title.prefix = NULL,
  binwidth = NULL,
  bar.measure = "count",
  xlab = NULL,
  stat.title = NULL,
  subtitle = NULL,
  caption = NULL,
  type = "parametric",
  test.value = 0,
  bf.prior = 0.707,
  bf.message = TRUE,
  robust.estimator = "onestep",
  effsize.type = "g",
  effsize.noncentral = TRUE,
  conf.level = 0.95,
  nboot = 100,
  k = 2,
  ggtheme = ggplot2::theme_bw(),
  ggstatsplot.layer = TRUE,
  fill.gradient = FALSE,
  low.color = "#0072B2",
  high.color = "#D55E00",
  bar.fill = "grey50",
  results.subtitle = TRUE,
  centrality.para = "mean",
  centrality.color = "blue",
  centrality.size = 1,
  centrality.linetype = "dashed",
  centrality.line.labeller = TRUE,
  centrality.k = 2,
  test.value.line = FALSE,
  test.value.color = "black",
  test.value.size = 1,
  test.value.linetype = "dashed",
  test.line.labeller = TRUE,
  test.k = 0,
  normal.curve = FALSE,
  normal.curve.color = "black",
  normal.curve.linetype = "solid",
  normal.curve.size = 1,
  ggplot.component = NULL,
  return = "plot",
  messages = TRUE,
  ...
)
}
\arguments{
\item{data}{A dataframe (or a tibble) from which variables specified are to
be taken. A matrix or tables will \strong{not} be accepted.}

\item{x}{A numeric variable.}

\item{grouping.var}{A single grouping variable (can be entered either as a
bare name \code{x} or as a string \code{"x"}).}

\item{title.prefix}{Character string specifying the prefix text for the fixed
plot title (name of each factor level) (Default: \code{NULL}). If \code{NULL}, the
variable name entered for \code{grouping.var} will be used.}

\item{binwidth}{The width of the histogram bins. Can be specified as a
numeric value, or a function that calculates width from \code{x}. The default is
to use the \code{max(x) - min(x) / sqrt(N)}. You should always check this value
and explore multiple widths to find the best to illustrate the stories in
your data.}

\item{bar.measure}{Character describing what value needs to be represented as
height in the bar chart. This can either be \code{"count"}, which shows number
of points in bin, or \code{"density"}, which density of points in bin, scaled to
integrate to 1, or "\code{proportion}", which shows relative frequencies of
observations in each bin, or "\code{mix}", which shows \emph{both} count and
proportion in the same plot.}

\item{xlab}{Labels for \code{x} and \code{y} axis variables. If \code{NULL} (default),
variable names for \code{x} and \code{y} will be used.}

\item{stat.title}{A character describing the test being run, which will be
added as a prefix in the subtitle. The default is \code{NULL}. An example of a
\code{stat.title} argument will be something like \code{"Student's t-test: "}.}

\item{subtitle}{The text for the plot subtitle. Will work only if
\code{results.subtitle = FALSE}.}

\item{caption}{The text for the plot caption.}

\item{type}{Type of statistic expected (\code{"parametric"} or \code{"nonparametric"}
or \code{"robust"} or \code{"bayes"}).Corresponding abbreviations are also accepted:
\code{"p"} (for parametric), \code{"np"} (nonparametric), \code{"r"} (robust), or
\code{"bf"}resp.}

\item{test.value}{A number specifying the value of the null hypothesis
(Default: \code{0}).}

\item{bf.prior}{A numeric value between \code{0.5} and \code{2} (default \code{0.707}), the
prior width to use in calculating Bayes Factors.}

\item{bf.message}{Logical that decides whether to display Bayes Factor in
favor of the \emph{null} hypothesis. This argument is relevant only \strong{for
parametric test} (Default: \code{TRUE}).}

\item{robust.estimator}{If \code{type = "robust"}, a robust estimator to be used
(\code{"onestep"} (Default), \code{"mom"}, or \code{"median"}). For more, see
\code{?WRS2::onesampb}.}

\item{effsize.type}{Type of effect size needed for \emph{parametric} tests. The
argument can be \code{"biased"} (\code{"d"} for Cohen's \emph{d}) or \code{"unbiased"}
(\code{"g"} Hedge's \emph{g} for \strong{t-test}). The default is \code{"g"}.}

\item{effsize.noncentral}{Logical indicating whether to use non-central
\emph{t}-distributions for computing the confidence interval for Cohen's \emph{d}
or Hedge's \emph{g} (Default: \code{TRUE}).}

\item{conf.level}{Scalar between 0 and 1. If unspecified, the defaults return
\verb{95\%} lower and upper confidence intervals (\code{0.95}).}

\item{nboot}{Number of bootstrap samples for computing confidence interval
for the effect size (Default: \code{100}).}

\item{k}{Number of digits after decimal point (should be an integer)
(Default: \code{k = 2}).}

\item{ggtheme}{A function, \code{ggplot2} theme name. Default value is
\code{ggplot2::theme_bw()}. Any of the \code{ggplot2} themes, or themes from
extension packages are allowed (e.g., \code{ggthemes::theme_fivethirtyeight()},
\code{hrbrthemes::theme_ipsum_ps()}, etc.).}

\item{ggstatsplot.layer}{Logical that decides whether \code{theme_ggstatsplot}
theme elements are to be displayed along with the selected \code{ggtheme}
(Default: \code{TRUE}). \code{theme_ggstatsplot} is an opinionated theme layer that
override some aspects of the selected \code{ggtheme}.}

\item{fill.gradient}{Logical decides whether color fill gradient is to be
displayed (Default: \code{FALSE}). If \code{FALSE}, the legend and the color gradient
will also be removed. The default is set to \code{FALSE} because the gradient
provides redundant information in light of y-axis labels.}

\item{low.color}{Colors for low and high ends of the gradient.
Defaults are colorblind-friendly.}

\item{high.color}{Colors for low and high ends of the gradient.
Defaults are colorblind-friendly.}

\item{bar.fill}{If \code{fill.gradient = FALSE}, then \code{bar.fill} decides which
color will uniformly fill all the bars in the histogram (Default:
\code{"grey50"}).}

\item{results.subtitle}{Decides whether the results of statistical tests are
to be displayed as a subtitle (Default: \code{TRUE}). If set to \code{FALSE}, only
the plot will be returned.}

\item{centrality.para}{Decides \emph{which} measure of central tendency (\code{"mean"}
or \code{"median"}) is to be displayed as a vertical line.}

\item{centrality.color}{Decides color for the vertical line for centrality
parameter (Default: \code{"blue"}).}

\item{centrality.size}{Decides size for the vertical line for centrality
parameter (Default: \code{1.2}).}

\item{centrality.linetype}{Decides linetype for the vertical line for
centrality parameter (Default: \code{"dashed"}).}

\item{centrality.line.labeller}{A logical that decides whether line labels
should be displayed for the \strong{centrality.para} line (Default: \code{TRUE}).}

\item{centrality.k}{Integer denoting the number of decimal places expected
for centrality parameter label. (Default: \code{2}).}

\item{test.value.line}{Decides whether test value is to be displayed as a
vertical line (Default: \code{FALSE}).}

\item{test.value.color}{Decides color for the vertical line denoting test
value (Default: \code{"black"}).}

\item{test.value.size}{Decides size for the vertical line for test value
(Default: \code{1.2}).}

\item{test.value.linetype}{Decides linetype for the vertical line for test
value (Default: \code{"dashed"}).}

\item{test.line.labeller}{A logical that decides whether line labels should
be displayed for \strong{test.value} line (Default: \code{TRUE}).}

\item{test.k}{Integer denoting the number of decimal places expected for
\code{test.value} label. (Default: \code{0} ).}

\item{normal.curve}{Logical decides whether to super-impose a normal curve
using \code{stats::dnorm(mean(x), sd(x))}. Default is \code{FALSE}.}

\item{normal.curve.color}{If
\code{normal.curve = TRUE}, then these arguments can be used to modify color
(Default: \code{"black"}), size (default: \code{1.0}), linetype (default: \code{"solid"}).}

\item{normal.curve.linetype}{If
\code{normal.curve = TRUE}, then these arguments can be used to modify color
(Default: \code{"black"}), size (default: \code{1.0}), linetype (default: \code{"solid"}).}

\item{normal.curve.size}{If
\code{normal.curve = TRUE}, then these arguments can be used to modify color
(Default: \code{"black"}), size (default: \code{1.0}), linetype (default: \code{"solid"}).}

\item{ggplot.component}{A \code{ggplot} component to be added to the plot prepared
by \code{ggstatsplot}. This argument is primarily helpful for \code{grouped_} variant
of the current function. Default is \code{NULL}. The argument should be entered
as a function. If the given function has an argument \code{axes.range.restrict}
and if it has been set to \code{TRUE}, the added \code{ggplot} component \emph{might} not
work as expected.}

\item{return}{Character that describes what is to be returned: can be
\code{"plot"} (default) or \code{"subtitle"} or \code{"caption"}. Setting this to
\code{"subtitle"} will return the expression containing statistical results. If
you have set \code{results.subtitle = FALSE}, then this will return a \code{NULL}.
Setting this to \code{"caption"} will return the expression containing details
about Bayes Factor analysis, but valid only when \code{type = "parametric"} and
\code{bf.message = TRUE}, otherwise this will return a \code{NULL}.}

\item{messages}{Decides whether messages references, notes, and warnings are
to be displayed (Default: \code{TRUE}).}

\item{...}{
  Arguments passed on to \code{\link[=combine_plots]{combine_plots}}
  \describe{
    \item{\code{title.text}}{String or plotmath expression to be drawn as title for the
\emph{combined plot}.}
    \item{\code{title.color}}{Text color for title.}
    \item{\code{title.size}}{Point size of title text.}
    \item{\code{title.vjust}}{Vertical justification for title. Default = \code{0.5}
(centered on \code{y}). \code{0} = baseline at \code{y}, \code{1} = ascender at \code{y}.}
    \item{\code{title.hjust}}{Horizontal justification for title. Default = \code{0.5}
(centered on \code{x}). \code{0} = flush-left at x, \code{1} = flush-right.}
    \item{\code{title.fontface}}{The font face (\code{"plain"}, \code{"bold"} (default),
\code{"italic"}, \code{"bold.italic"}) for title.}
    \item{\code{caption.text}}{String or plotmath expression to be drawn as the caption
for the \emph{combined plot}.}
    \item{\code{caption.color}}{Text color for caption.}
    \item{\code{caption.size}}{Point size of title text.}
    \item{\code{caption.vjust}}{Vertical justification for caption. Default = \code{0.5}
(centered on y). \code{0} = baseline at y, \code{1} = ascender at y.}
    \item{\code{caption.hjust}}{Horizontal justification for caption. Default = \code{0.5}
(centered on x). \code{0} = flush-left at x, \code{1} = flush-right.}
    \item{\code{caption.fontface}}{The font face (\code{"plain"} (default), \code{"bold"},
\code{"italic"}, \code{"bold.italic"}) for caption.}
    \item{\code{sub.text}}{The label with which the \emph{combined plot} should be annotated.
Can be a plotmath expression.}
    \item{\code{sub.color}}{Text color for annotation label (Default: \code{"black"}).}
    \item{\code{sub.size}}{Point size of annotation text (Default: \code{12}).}
    \item{\code{sub.x}}{The x position of annotation label (Default: \code{0.5}).}
    \item{\code{sub.y}}{The y position of annotation label (Default: \code{0.5}).}
    \item{\code{sub.hjust}}{Horizontal justification for annotation label (Default:
\code{0.5}).}
    \item{\code{sub.vjust}}{Vertical justification for annotation label (Default:
\code{0.5}).}
    \item{\code{sub.vpadding}}{Vertical padding. The total vertical space added to the
label, given in grid units. By default, this is added equally above and
below the label. However, by changing the y and vjust parameters, this can
be changed (Default: \code{ggplot2::unit(1, "lines")}).}
    \item{\code{sub.fontface}}{The font face (\code{"plain"} (default), \code{"bold"}, \code{"italic"},
\code{"bold.italic"}) for the annotation label.}
    \item{\code{sub.angle}}{Angle at which annotation label is to be drawn (Default:
\code{0}).}
    \item{\code{sub.lineheight}}{Line height of annotation label.}
    \item{\code{title.caption.rel.heights}}{Numerical vector of relative columns heights
while combining (title, plot, caption).}
    \item{\code{title.rel.heights}}{Numerical vector of relative columns heights while
combining (title, plot).}
    \item{\code{caption.rel.heights}}{Numerical vector of relative columns heights while
combining (plot, caption).}
  }}
}
\description{
Helper function for \code{ggstatsplot::gghistostats} to apply this
function across multiple levels of a given factor and combining the
resulting plots using \code{ggstatsplot::combine_plots}.
}
\examples{
\donttest{
# for reproducibility
set.seed(123)

# plot
ggstatsplot::grouped_gghistostats(
  data = iris,
  x = Sepal.Length,
  test.value = 5,
  grouping.var = Species,
  bar.fill = "orange",
  nrow = 1,
  ggplot.component = list(
    ggplot2::scale_x_continuous(breaks = seq(3, 9, 1), limits = (c(3, 9))),
    ggplot2::scale_y_continuous(breaks = seq(0, 25, 5), limits = (c(0, 25)))
  ),
  messages = FALSE
)
}
}
\references{
\url{https://indrajeetpatil.github.io/ggstatsplot/articles/web_only/gghistostats.html}
}
\seealso{
\code{\link{gghistostats}}, \code{\link{ggdotplotstats}},
\code{\link{grouped_ggdotplotstats}}
}
