% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotation-tern.R
\name{annotate}
\alias{annotate}
\title{Create an annotation layer (ggtern version).}
\usage{
annotate(geom, x = NULL, y = NULL, z = NULL, xmin = NULL, xmax = NULL,
  ymin = NULL, ymax = NULL, zmin = NULL, zmax = NULL, xend = NULL,
  yend = NULL, zend = NULL, ..., na.rm = FALSE)
}
\arguments{
\item{geom}{name of geom to use for annotation}

\item{x, y, z, xmin, ymin, zmin, xmax, ymax, zmax, xend, yend, zend}{positioning aesthetics -
you must specify at least one of these.}

\item{...}{other arguments passed on to \code{\link{layer}}. These are
often aesthetics, used to set an aesthetic to a fixed value, like
\code{color = "red"} or \code{size = 3}. They may also be parameters
to the paired geom/stat.}

\item{na.rm}{If \code{FALSE} (the default), removes missing values with
a warning.  If \code{TRUE} silently removes missing values.}
}
\description{
This function adds geoms to a plot. Unlike typical a geom function,
the properties of the geoms are not mapped from variables of a data frame,
but are instead passed in as vectors. This is useful for adding small annotations
(such as text labels) or if you have your data in vectors, and for some
reason don't want to put them in a data frame.
}
\details{
Note that all position aesthetics are scaled (i.e. they will expand the
limits of the plot so they are visible), but all other aesthetics are
set. This means that layers created with this function will never
affect the legend.
}
\examples{
ggtern() + 
annotate(geom  = 'text',
              x     = c(0.5,1/3,0.0),
              y     = c(0.5,1/3,0.0),
              z     = c(0.0,1/3,1.0),
              angle = c(0,30,60),
              vjust = c(1.5,0.5,-0.5),
              label = paste("Point",c("A","B","C")),
              color = c("green","red",'blue')) +
  theme_dark() + 
  theme_nomask()
}
\seealso{
\code{\link[ggplot2]{annotate}}
}

