% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wsj.R
\name{wsj_pal}
\alias{wsj_pal}
\title{Wall Street Journal color palette (discrete)}
\usage{
wsj_pal(palette = "colors6")
}
\arguments{
\item{palette}{\code{character} The color palette to use. This
must be a name in
\code{\link[=ggthemes_data]{ggthemes_data$wsj$palettes}}.}
}
\description{
The Wall Street Journal uses many different color palettes in its
plots. This collects a few of them, but is by no means exhaustive.
Collections of these plots can be found on the WSJ Graphics
\href{https://twitter.com/WSJGraphics}{Twitter} feed and
\href{https://pinterest.com/wsjgraphics/wsj-graphics/}{Pinterest}.
}
\section{Palettes}{


The following palettes are defined,

\describe{
\item{rgby}{Red/Green/Blue/Yellow theme.
  Examples: \url{https://twitpic.com/b2e3v2}. Up to four values.}
  \item{red_green}{Green/red two-color scale for good/bad. Examples:
\url{https://twitpic.com/b1avj6}, \url{http://twitpic.com/a4kxcl}.}
\item{green_black}{Black-green 4-color scale for 'Very negative',
  'Somewhat negative', 'somewhat positive', 'very positive'.
  Examples: \url{https://twitpic.com/awbua0}.}
\item{dem_rep}{Democrat/Republican/Undecided blue/red/gray scale.
  Examples: \url{https://twitpic.com/awbua0}.}
\item{colors6}{Red, blue, gold, green, orange, and black palette.
  Examples: \url{https://twitpic.com/9gfg5q}.}
}
}

\seealso{
Other colour wsj: \code{\link{scale_colour_wsj}}
}
