% Generated by roxygen2 (4.0.2): do not edit by hand
\name{add_legend}
\alias{add_legend}
\alias{hide_legend}
\title{Add a vega legend specification to a ggvis plot}
\usage{
add_legend(vis, scales = NULL, orient = "right", title = NULL,
  format = NULL, values = NULL, properties = NULL)

hide_legend(vis, scales)
}
\arguments{
\item{vis}{A ggvis object.}

\item{scales}{The name of one or more scales for which to add a legend.
Typically one of "size", "shape", "fill", "stroke", although custom scale
names may also be used. Multiple names can also be used, like
\code{c("fill", "shape")}.}

\item{orient}{The orientation of the legend. One of "left" or "right". This
determines how the legend is positioned within the scene. The default is
"right".}

\item{title}{A title for the legend. By default, it uses the name the fields
used in the legend. Use \code{""} to suppress the title.}

\item{format}{The formatting pattern for axis labels. Vega uses D3's format
pattern: \url{https://github.com/mbostock/d3/wiki/Formatting}}

\item{values}{Explicitly set the visible legend values.}

\item{properties}{Optional mark property definitions for custom legend
styling. Should be an object created by \code{\link{legend_props}}, with
properties for title, label, symbols, gradient, legend.}
}
\description{
Axis specifications allow you to either override the default legends,
or supply additional legends.
}
\details{
More information about axes can be found in the "axes and legends" vignettes.
}
\section{Compared to ggplot2}{


In ggplot2, legend (and axis) properties are part of the scales
specification. In vega, they are separate, which allows the specification
of multiple legends, and more flexible linkage between scales and legends.
}
\examples{
mtcars \%>\% ggvis(x = ~wt, y = ~mpg, fill = ~cyl) \%>\%
  layer_points() \%>\%
  add_legend("fill", title = "Cylinders")

# Suppress legend with hide_legend
mtcars \%>\% ggvis(x = ~wt, y = ~mpg, fill = ~cyl) \%>\%
  layer_points() \%>\%
  hide_legend("fill")

# Combining two properties in one legend
mtcars \%>\%
  ggvis(x = ~wt, y = ~mpg, fill = ~factor(cyl), shape = ~factor(cyl)) \%>\%
  layer_points() \%>\%
  add_legend(c("fill", "shape"))

# Control legend properties with a continuous legend, with x and y position
# in pixels.
mtcars \%>\% ggvis(x = ~wt, y = ~mpg, fill = ~cyl) \%>\%
  layer_points() \%>\%
  add_legend("fill", title = "Cylinders",
    properties = legend_props(
      title = list(fontSize = 16),
      labels = list(fontSize = 12, fill = "#00F"),
      gradient = list(stroke = "red", strokeWidth = 2),
      legend = list(x = 500, y = 50)
    )
  )

# Control legend properties with a categorical legend, with x and y position
# in the scaled data space.
mtcars \%>\% ggvis(x = ~wt, y = ~mpg, fill = ~factor(cyl)) \%>\%
  layer_points() \%>\%
  add_legend("fill", title = "Cylinders",
    properties = legend_props(
      title = list(fontSize = 16),
      labels = list(fontSize = 14, dx = 5),
      symbol = list(stroke = "black", strokeWidth = 2,
        shape = "square", size = 200),
      legend = list(
        x = scaled_value("x", 4.5),
        y = scaled_value("y", 30)
      )
    )
  )

# Control legend position using x_rel and y_rel which specify relative
# position, going from 0 to 1. (0, 0) is the bottom-left corner, and
# (1, 1) is the upper-right corner. The values control the position of
# the upper-left corner of the legend.
mtcars \%>\% ggvis(x = ~wt, y = ~mpg, fill = ~cyl) \%>\%
  layer_points() \%>\%
  add_relative_scales() \%>\%
  add_legend("fill", title = "Cylinders",
    properties = legend_props(
      legend = list(
        x = scaled_value("x_rel", 0.8),
        y = scaled_value("y_rel", 1)
      )
    )
  )
}

