% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fortify_voronoi.R
\name{fortify_voronoi}
\alias{fortify_voronoi}
\title{Create Data Frame from voronoi_polygons output}
\usage{
fortify_voronoi(vor_spdf)
}
\arguments{
\item{vor_spdf}{Output from \code{\link[ggvoronoi]{voronoi_polygon}} (\code{\link[sp]{SpatialPolygonsDataFrame}})}
}
\description{
Allows output of \code{\link[ggvoronoi]{voronoi_polygon}} to be plotted using
\code{\link[ggplot2]{geom_polygon}}.
}
\examples{
set.seed(45056)
x <- sample(1:200,100)
y <- sample(1:200,100)
points <- data.frame(x, y,
                     distance = sqrt((x-100)^2 + (y-100)^2))
circle <- data.frame(x = 100*(1+cos(seq(0, 2*pi, length.out = 2500))),
                     y = 100*(1+sin(seq(0, 2*pi, length.out = 2500))),
                     group = rep(1,2500))

vor_spdf <- voronoi_polygon(data=points,x="x",y="y",outline=circle)
vor_df <- fortify_voronoi(vor_spdf)

ggplot(vor_df) +
    geom_polygon(aes(x=x,y=y,fill=distance,group=group))
}
\keyword{choropleth}
\keyword{voronoi,}
