% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/github_with_pat.R
\name{github_with_pat}
\alias{github_with_pat}
\alias{with_pat}
\alias{local_pat}
\title{\code{withr}-like functions for temporary personal access token}
\usage{
with_pat(new, code)

local_pat(new, .local_envir = parent.frame())
}
\arguments{
\item{new}{Temporary GitHub access token}

\item{code}{Code to execute with the temporary token}

\item{.local_envir}{The environment to use for scoping.}
}
\value{
The results of the evaluation of the code argument.
}
\description{
Temporarily change the \code{GITHUB_PAT} environmental variable for
GitHub authentication. Based on the \code{withr} interface.
}
\details{
if \code{new = NA} is used the \code{GITHUB_PAT} environment variable will be unset.
}
\examples{
\dontrun{
with_pat("1234", print(github_get_token()))
}

}
