% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/org.R, R/org_sitrep.R, R/org_update.R
\name{org_perm}
\alias{org_perm}
\alias{org_sitrep}
\alias{org_set_repo_permission}
\title{Organization permissions}
\usage{
org_sitrep(org)

org_set_repo_permission(org, permission = c("none", "read", "write", "admin"))
}
\arguments{
\item{org}{Character. Name of the GitHub organization(s).}

\item{permission}{Default permission level members have for organization repositories:
\itemize{
\item read - can pull, but not push to or administer this repository.
\item write - can pull and push, but not administer this repository.
\item admin - can pull, push, and administer this repository.
\item none - no permissions granted by default.
}}
}
\value{
\code{org_sitep()} invisibly returns the \code{org} argument.

\code{org_set_repo_permission()} invisibly return a the result of the relevant GitHub API call.
}
\description{
\itemize{
\item \code{org_sitrep()} - Provides a situation report on a GitHub organization.
\item \code{org_set_repo_permission()} - Change the default permission level for org repositories.
}
}
\examples{
\dontrun{
org_sitrep("ghclass-test")

org_set_repo_permission("ghclass-test", "read")

org_sitrep("ghclass-test")

# Cleanup
org_set_repo_permission("ghclass-test", "none")
}

}
