% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ghypClasses.R, R/ghypGenericMethods.R
\docType{class}
\name{ghyp.attribution-class}
\alias{ghyp.attribution-class}
\alias{contribution}
\alias{contribution,ghyp.attribution-method}
\alias{sensitivity}
\alias{sensitivity,ghyp.attribution-method}
\alias{weights,ghyp.attribution-method}
\title{Class ghyp.attribution}
\usage{
contribution(object, ...)

\S4method{contribution}{ghyp.attribution}(object, percentage = FALSE)

sensitivity(object)

\S4method{sensitivity}{ghyp.attribution}(object)

\S4method{weights}{ghyp.attribution}(object)
}
\arguments{
\item{object}{an object inheriting from class \code{\link[=ghyp.attribution-class]{ghyp.attribution}}.}

\item{\dots}{additional parameters.}

\item{percentage}{boolean. Display figures in percent. (Default=FALSE).}
}
\value{
contribution of each asset to portfolio's overall expected shortfall.

sensitivity of each asset to portfolio's overall expected shortfall.

weights of each asset within portfolio.
}
\description{
The class \dQuote{ghyp.attribution} contains the Expected Shortfall of 
 the portfolio as well as the contribution of each asset to the total risk
 and the sensitivity of each Asset. The sensitivity gives an information 
 about the overall risk modification of the portfolio if the weight in a 
 given asset is marginally increased or decreased (1 percent).

The function \code{contribution} returns the contribution of the assets to the portfolio expected shortfall.
}
\details{
Expected shortfall enjoys homogeneity, sub-additivity, and co-monotonic additivity. Its associated function is continuously differentiable under
moderate assumptions on the joint distribution of the assets.
}
\section{Slots}{

\describe{
\item{\code{ES}}{Portfolio's expected shortfall (ES) for a given confidence level. Class \code{matrix}.}

\item{\code{contribution}}{Contribution of each asset to the overall ES. Class \code{matrix}.}

\item{\code{sensitivity}}{Sensitivity of each asset. Class \code{matrix}.}

\item{\code{weights}}{Weight of each asset.}
}}

\note{
When showing special cases of the generalized hyperbolic distribution
the corresponding fixed parameters are not printed.
}
\section{Objects from the Class}{

Objects should only be created by calls to the constructors \code{\link{ESghyp.attribution}}.
}

\examples{
\dontrun{
data(smi.stocks)
multivariate.fit <- fit.ghypmv(data = smi.stocks,
opt.pars = c(lambda = FALSE, alpha.bar = FALSE),
lambda = 2)

portfolio <- ESghyp.attribution(0.01, multivariate.fit)
summary(portfolio)
}
}
\seealso{
\code{\link{ESghyp.attribution}}, \code{\link{ghyp.attribution-class}} to
compute the expected shortfall attribution.
}
\author{
Marc Weibel

Marc Weibel
}
\keyword{attribution}
\keyword{classes}
\keyword{risk}
