% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots-norm.R
\name{plot_crispr}
\alias{plot_crispr}
\title{Plot CRISPR scores after normalization}
\usage{
plot_crispr(.data = NULL, gimap_dataset, output_file = "crispr_norm_plot.png")
}
\arguments{
\item{.data}{Data can be piped in with tidyverse pipes from function to
function. But the data must still be a gimap_dataset}

\item{gimap_dataset}{A special dataset structure that is setup using the
`setup_data()` function.}

\item{output_file}{A file for the output}
}
\value{
A ggplot2 boxplot of the CRISPR scores separated by the type of
target. Can be used to determine the normalization has proceeded properly.
}
\description{
This plots normalization after CRISPR scores have been calculated
}
\examples{
\donttest{

gimap_dataset <- get_example_data("gimap") \%>\%
  gimap_filter() \%>\%
  gimap_annotate(cell_line = "HELA") \%>\%
  gimap_normalize(
    timepoints = "day",
    missing_ids_file =  tempfile()
  )

# Plot:
plot_crispr(gimap_dataset)
}
}
