% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lowest.z.R
\name{lowest.z}
\alias{lowest.z}
\title{Identifies lowest z value from list of z values.}
\usage{
lowest.z(z_list, elig_paths, prop_cutoff, n_subj, test_cutoff)
}
\arguments{
\item{z_list}{A list of z values across individuals.}

\item{elig_paths}{A character vector containing eligible paths that
gimme is allowed to drop from the model at a given stage.}

\item{prop_cutoff}{The proportion of individuals for whom a path must be
nonsignificant in order for it to be dropped from the models. NULL if used 
at the individual-level.}

\item{n_subj}{The number of subjects in a given stage of the search. If
in the group stage, n_subj equals the number of subjects. If in the subgroup
stage, n_subj equals the number of individuals in a given subgroup. At the 
individual stage, n_subj = 1.}

\item{test_cutoff}{Z score cutoff for significance testing.}
}
\value{
Returns name of parameter associated with lowest z. If no z meets 
the criteria, returns NA.
}
\description{
Identifies lowest z value from list of z values.
}
\keyword{internal}
