% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/downloadGimms.R
\docType{methods}
\name{downloadGimms}
\alias{downloadGimms}
\alias{downloadGimms,Date-method}
\alias{downloadGimms,character-method}
\alias{downloadGimms,missing-method}
\alias{downloadGimms,numeric-method}
\title{Download GIMMS 3G data}
\usage{
\S4method{downloadGimms}{Date}(x, y, dsn = getwd(), overwrite = FALSE,
  quiet = TRUE, mode = "wb", cores = 1L, ...)

\S4method{downloadGimms}{numeric}(x, y, dsn = getwd(), overwrite = FALSE,
  quiet = TRUE, mode = "wb", cores = 1L, ...)

\S4method{downloadGimms}{character}(x, dsn = getwd(), overwrite = FALSE,
  quiet = TRUE, mode = "wb", cores = 1L, ...)

\S4method{downloadGimms}{missing}(dsn = getwd(), overwrite = FALSE,
  quiet = TRUE, mode = "wb", cores = 1L, ...)
}
\arguments{
\item{x}{If 'Date', start date for download (e.g. "2000-01-01"). If
'numeric', start year for download (e.g. 2000). If 'character', a vector of
full online filepath(s) to download, typically returned from
\code{\link{updateInventory}}. If not supplied, download will start from the
oldest file available.}

\item{y}{If 'Date', end date for download. If 'numeric', end year for
download. If not supplied, download will stop with the latest file available.}

\item{dsn}{'character'. Destination folder for file download. If not supplied,
all downloaded files will be stored in the current working directory.}

\item{overwrite}{Logical. If \code{TRUE}, already downloaded files in 'dsn'
will be overwritten.}

\item{quiet}{Logical. If \code{TRUE}, information sent to the console is
reduced.}

\item{mode}{See \code{\link{download.file}}.}

\item{cores}{Integer. Number of cores for parallel computing.}

\item{...}{Further arguments passed on to \code{\link{download.file}}, e.g.
'method'.}
}
\value{
A vector of filepaths.
}
\description{
Download GIMMS 3G binary data for a given time span from the NASA Ames
Ecological Forecasting Lab's FTP server
(\url{http://ecocast.arc.nasa.gov/data/pub/gimms/3g.v0/}, accessed on
January 15, 2016).
}
\examples{
\dontrun{
## Destination folder for data download
gimms_dir <- paste0(getwd(), "/data")

## 'Date' method
gimms_files_date <- downloadGimms(x = as.Date("2000-01-01"),
                                  y = as.Date("2000-06-30"),
                                  dsn = gimms_dir)

## 'numeric' method, i.e. full years
gimms_files_year <- downloadGimms(x = 2000, y = 2002, dsn = gimms_dir)

## 'character' method, i.e. file names
gimms_files <- updateInventory()
gimms_files <- gimms_files[grep("geo00", gimms_files)]
gimms_files_char <- downloadGimms(x = gimms_files, dsn = gimms_dir)

## 'missing' method, i.e. entire collection
gimms_files_full <- downloadGimms(dsn = gimms_dir)
}

}
\author{
Florian Detsch
}
\seealso{
\code{\link{download.file}}
}

