% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare_orthogonal_matrix.R
\name{prepare_orthogonal_matrix}
\alias{prepare_orthogonal_matrix}
\title{Prepare orthogonal matrix}
\usage{
prepare_orthogonal_matrix(perm, perm_size = NULL, basis = NULL)
}
\arguments{
\item{perm}{An object of a \code{gips_perm} or a \code{permutations::cycle} class.}

\item{perm_size}{Size of a permutation.
Required if \code{perm} is of a \code{permutations::cycle} class.}

\item{basis}{A matrix with basis vectors in COLUMNS. Identity by default.}
}
\value{
A square matrix of size \code{perm_size} by \code{perm_size} with
columns from vector elements \eqn{v_k^{(c)}} according to
\href{https://arxiv.org/abs/2004.03503}{Theorem 6 from references}.
}
\description{
Calculate orthogonal matrix U_Gamma for decomposition in
\href{https://arxiv.org/abs/2004.03503}{Theorem 1 from references}.
}
\details{
Given X - a matrix invariant under the permutation \code{perm}. Call Gamma
the permutations cyclic group \eqn{<perm> = \{perm, perm^2, ...\}}.

Then, U_Gamma is such an orthogonal matrix, which block-diagonalizes X.

To be more precise, the matrix \code{t(U_Gamma) \%*\% X \%*\% U_Gamma} has a
block-diagonal structure, which is ensured by
\href{https://arxiv.org/abs/2004.03503}{Theorem 1 from references}

Formula for U_Gamma can be found in
\href{https://arxiv.org/abs/2004.03503}{Theorem 6 from references}.
}
\examples{
gperm <- gips_perm("(1,2,3)(4,5)", 5)
U_Gamma <- prepare_orthogonal_matrix(gperm)

number_of_observations <- 10
X <- matrix(rnorm(5 * number_of_observations), number_of_observations, 5)
S <- cov(X)
X <- project_matrix(S, perm = gperm) # this matrix in invariant under gperm

block_decomposition <- t(U_Gamma) \%*\% X \%*\% U_Gamma
round(block_decomposition, 5) # the non-zeros only on diagonal and [1,2] and [2,1]
}
\references{
Piotr Graczyk, Hideyuki Ishi, Bartosz Kołodziejek, Hélène Massam.
"Model selection in the space of Gaussian models invariant by symmetry."
The Annals of Statistics, 50(3) 1747-1774 June 2022.
\href{https://arxiv.org/abs/2004.03503}{arXiv link};
\doi{10.1214/22-AOS2174}
}
\seealso{
\itemize{
\item \code{\link[=project_matrix]{project_matrix()}} - A function used in examples
to show the properties of \code{prepare_orthogonal_matrix()}.
\item \strong{Block Decomposition - [1], Theorem 1} section of
\code{vignette("Theory", package = "gips")} or its
\href{https://przechoj.github.io/gips/articles/Theory.html}{pkgdown page}) -
A place to learn more about the math behind the \code{gips} package
and see more examples of \code{prepare_orthogonal_matrix()}.
}
}
