% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gips_class.R
\name{as.character.gips}
\alias{as.character.gips}
\title{Transform the \code{gips} object to a character vector}
\usage{
\method{as.character}{gips}(x, ...)
}
\arguments{
\item{x}{An object of a \code{gips} class.}

\item{...}{Further arguments (currently ignored).}
}
\value{
Returns an object of a \code{character} type.
}
\description{
Implementation of the S3 method.
}
\examples{
A <- matrix(rnorm(4 * 4), nrow = 4)
S <- t(A) \%*\% A
g <- gips(S, 14, perm = "(123)")
as.character(g)
}
\seealso{
\itemize{
\item \code{\link[=as.character.gips_perm]{as.character.gips_perm()}} - The underlying \code{gips_perm} of
the \code{gips} object is passed to \code{\link[=as.character.gips_perm]{as.character.gips_perm()}}.
\item \code{\link[permutations:print]{permutations::as.character.cycle()}} - The underlying permutation of
the \code{gips} object is passed to \code{\link[permutations:print]{permutations::as.character.cycle()}}.
}
}
