% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gisco_get_coastallines.R
\name{gisco_get_coastallines}
\alias{gisco_get_coastallines}
\title{Download Coastal Lines from GISCO}
\source{
\href{https://gisco-services.ec.europa.eu/distribution/v2/coas/}{GISCO Coastal Lines}
}
\usage{
gisco_get_coastallines(
  resolution = "20",
  year = "2016",
  epsg = "4326",
  cache = TRUE,
  update_cache = FALSE,
  cache_dir = NULL
)
}
\arguments{
\item{resolution}{Resolution of the geospatial data. One of
\itemize{
   \item "60" (1:60million),
   \item "20" (1:20million)
   \item "10" (1:10million)
   \item "03" (1:3million) or
   \item "01" (1:1million).
   }}

\item{year}{Release year. One of
"2006", "2010", "2013" or "2016"}

\item{epsg}{projection of the map: 4-digit \href{https://spatialreference.org/ref/epsg/}{EPSG code}. One of:
\itemize{
\item "4326" - WGS84
\item "3035" - ETRS89 / ETRS-LAEA
\item "3857" - Pseudo-Mercator
}}

\item{cache}{a logical whether to do caching. Default is \code{TRUE}.}

\item{update_cache}{a logical whether to update cache.}

\item{cache_dir}{a path to a cache directory. The directory have to exist.  The \code{NULL} (default) uses and creates \code{/gisco} directory in the temporary directory from \code{\link{tempdir}}. The directory can also be set with \code{options(gisco_cache_dir = <path>}.}
}
\value{
a \code{POLYGON} object on \code{sf} format.
}
\description{
Downloads a simple feature (\code{sf}) object.
}
\note{
Please check the download and usage provisions on \link{gisco_attributions}.
}
\examples{
library(sf)

coastlines <- gisco_get_coastallines()
plot(st_geometry(coastlines), col = "palegreen", border = "lightblue3")
title(main = "Coastal Lines",
      sub = gisco_attributions(copyright = FALSE),
      line = 1)
}
\author{
dieghernan, \url{https://github.com/dieghernan/}
}
