% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gisco_get_communes.R
\name{gisco_get_communes}
\alias{gisco_get_communes}
\title{Download Geospatial Communes Data from GISCO}
\source{
\href{https://gisco-services.ec.europa.eu/distribution/v2/communes/}{GISCO Communes}
}
\usage{
gisco_get_communes(
  year = "2016",
  epsg = "4326",
  update_cache = FALSE,
  cache_dir = NULL,
  spatialtype = "RG",
  country = NULL
)
}
\arguments{
\item{year}{Release year. One of
"2001", "2004", "2006", "2008", "2010", "2013" or 2016}

\item{epsg}{projection of the map: 4-digit \href{https://spatialreference.org/ref/epsg/}{EPSG code}. One of:
\itemize{
\item "4326" - WGS84
\item "3035" - ETRS89 / ETRS-LAEA
\item "3857" - Pseudo-Mercator
}}

\item{update_cache}{a logical whether to update cache.}

\item{cache_dir}{a path to a cache directory. The directory have to exist.  The \code{NULL} (default) uses and creates \code{/gisco} directory in the temporary directory from \code{\link{tempdir}}. The directory can also be set with \code{options(gisco_cache_dir = <path>)}.}

\item{spatialtype}{Type of geometry to be returned:
\itemize{
 \item RG: Regions - Multipolygon
 \item LB: Labels - Point
 \item BN: Boundaries - Multilines
 \item COASTL: coastlines - Multilines
 \item INLAND: inland boundaries - Multilines
}}

\item{country}{Optional. A character vector of country codes. See Details.}
}
\value{
a \code{sf} object.
}
\description{
Downloads a simple feature (\code{sf}) object.
}
\details{
\code{country} only available on specific datasets. Some \code{spatialtype} datasets (as Multilines data-types) may not have country-level identifies.

\code{country} could be either a vector of country names, a vector of ISO3 country codes or
a vector of Eurostat country codes.

If you experience any problem on download, try to download the file by any other method and set \code{cache_dir = <folder>}.
}
\note{
Please check the download and usage provisions on \link{gisco_attributions}.
}
\examples{
library(sf)

communes <- gisco_get_communes(country = "Belgique")
plot(
  st_geometry(communes),
  col = c("black", "gold", "brown2"),
  border = "grey90"
  )

title(
  main = "Communes on Belgium (2016)",
  sub = gisco_attributions(copyright = FALSE),
  line = 1,
  cex.sub = 0.8
  )
}
\seealso{
\link{gisco_get_lau}
}
\author{
dieghernan, \url{https://github.com/dieghernan/}
}
