% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gisco_get_nuts.R
\name{gisco_get_nuts}
\alias{gisco_get_nuts}
\title{Download Geospatial NUTS Data from GISCO}
\source{
\href{https://gisco-services.ec.europa.eu/distribution/v2/nuts/}{GISCO NUTS}
}
\usage{
gisco_get_nuts(
  resolution = "20",
  year = "2016",
  epsg = "4326",
  nuts_level = "all",
  cache = TRUE,
  update_cache = FALSE,
  cache_dir = NULL,
  spatialtype = "RG",
  country = NULL,
  nuts_id = NULL
)
}
\arguments{
\item{resolution}{Resolution of the geospatial data. One of
\itemize{
   \item "60" (1:60million),
   \item "20" (1:20million)
   \item "10" (1:10million)
   \item "03" (1:3million) or
   \item "01" (1:1million).
   }}

\item{year}{Release year. One of
"2003", "2006", "2010", "2013", "2016" or "2021".}

\item{epsg}{projection of the map: 4-digit \href{https://spatialreference.org/ref/epsg/}{EPSG code}. One of:
\itemize{
\item "4326" - WGS84
\item "3035" - ETRS89 / ETRS-LAEA
\item "3857" - Pseudo-Mercator
}}

\item{nuts_level}{NUTS level. One of "0" (Country-level), "1", "2" or "3". See \url{https://ec.europa.eu/eurostat/web/nuts/background}.}

\item{cache}{a logical whether to do caching. Default is \code{TRUE}.}

\item{update_cache}{a logical whether to update cache.}

\item{cache_dir}{a path to a cache directory. The directory have to exist.  The \code{NULL} (default) uses and creates \code{/gisco} directory in the temporary directory from \code{\link{tempdir}}. The directory can also be set with \code{options(gisco_cache_dir = <path>)}.}

\item{spatialtype}{Type of geometry to be returned:
\itemize{
 \item RG: Regions - Multipolygon
 \item LB: Labels - Point
 \item BN: Boundaries - Multilines
}}

\item{country}{Optional. A character vector of country codes. See Details}

\item{nuts_id}{Optional. A character vector of NUTS IDs.}
}
\value{
a \code{sf} object.
}
\description{
Downloads a simple feature (\code{sf}) object.
}
\details{
\code{country} only available when applicable.
Some \code{spatialtype} datasets (as Multilines data-types) may not have country-level identifies.

\code{country} could be either a vector of country names, a vector of ISO3 country codes or
a vector of Eurostat country codes.
}
\note{
Please check the download and usage provisions on \link{gisco_attributions}.
}
\examples{
library(sf)

nuts2 <- gisco_get_nuts(nuts_level = "2", country = "ITA")
nuts3 <- gisco_get_nuts(nuts_level = "3", country = "ITA")

plot(
  st_geometry(nuts3),
  lwd = 1,
  border = "grey40"
)
plot(st_geometry(nuts2),
     add = TRUE)
title(
  main = "NUTS2 and 3 Levels on Italy",
  sub = gisco_attributions(),
  cex.sub = 0.7,
  line = 1
)
}
\seealso{
\link{gisco_countrycode}, \link{gisco_nuts}
}
\author{
dieghernan, \url{https://github.com/dieghernan/}
}
