% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{gisco_coastallines}
\alias{gisco_coastallines}
\title{World coastal lines \code{POLYGON} object}
\format{
A \code{POLYGON} data frame (resolution: 1:20million, EPSG:4326) object with
3 variables:
\itemize{
\item \strong{FID}
\item \strong{COAS_ID}
\item \strong{geometry}: geometry field
}
}
\source{
\href{https://gisco-services.ec.europa.eu/distribution/v2/coas/geojson/}{COAS_RG_20M_2016_4326.geojson} file.
}
\description{
A \code{sf} object as provided by GISCO (2016 version).
}
\examples{

coasts <- gisco_coastallines

library(ggplot2)

ggplot(coasts) +
  geom_sf(color = "blue", fill = "blue", alpha = 0.2) +
  # Zoom on Oceania
  coord_sf(
    xlim = c(96, 179),
    ylim = c(-51, 11)
  ) +
  theme_minimal() +
  theme(
    plot.background = element_rect(
      fill = "black",
      color = "black"
    ),
    panel.grid = element_blank(),
    axis.text = element_text(colour = "grey90")
  )
}
\seealso{
\code{\link[=gisco_get_coastallines]{gisco_get_coastallines()}}

Other dataset: 
\code{\link{gisco_countries}},
\code{\link{gisco_countrycode}},
\code{\link{gisco_nuts}},
\code{\link{tgs00026}}
}
\concept{dataset}
