% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gist_map.R
\name{gist_map}
\alias{gist_map}
\title{Opens a full screen map after uploading a geojson file}
\usage{
gist_map(x, browse = TRUE)
}
\arguments{
\item{x}{An object of class \code{gist} generated by 
\code{\link{gist_create}} or \code{\link{gist_create_obj}}}

\item{browse}{Default: \code{TRUE}. Set to \code{FALSE} if you don't want to 
automatically browse to the URL.}
}
\description{
Takes a gist object and a input geojson file name and renders fullscreen map
}
\examples{
\dontrun{
file <- system.file("examples", "ecoengine_eg.geojson", package = "gistr")
gist_id <- gist_create(file, browse = FALSE)
gist_map(gist_id)
}
}
