% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/remote.r
\docType{methods}
\name{remote_remove}
\alias{remote_remove}
\alias{remote_remove,git_repository,character-method}
\title{Remove a remote}
\usage{
remote_remove(repo, name)

\S4method{remote_remove}{git_repository,character}(repo, name)
}
\arguments{
\item{repo}{The repository to work on}

\item{name}{The name of the remote to remove}
}
\value{
NULL, invisibly
}
\description{
All remote-tracking branches and configuration settings for the
remote will be removed.
}
\examples{
\dontrun{
## Initialize a temporary repository
path <- tempfile(pattern="git2r-")
dir.create(path)
repo <- init(path)

## Create a user and commit a file
config(repo, user.name="Alice", user.email="alice@example.org")
writeLines("Hello world!", file.path(path, "example.txt"))
add(repo, "example.txt")
commit(repo, "First commit message")

## Add a remote
remote_add(repo, "playground", "https://example.org/git2r/playground")
remotes(repo)
remote_url(repo, "playground")

## Rename a remote
remote_rename(repo, "playground", "foobar")
remotes(repo)
remote_url(repo, "foobar")

## Remove a remote
remote_remove(repo, "foobar")
remotes(repo)
}
}
\keyword{methods}

