% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/note.r
\docType{methods}
\name{note_default_ref}
\alias{note_default_ref}
\alias{note_default_ref,git_repository-method}
\title{Default notes reference}
\usage{
note_default_ref(repo)

\S4method{note_default_ref}{git_repository}(repo)
}
\arguments{
\item{repo}{The repository}
}
\value{
Character vector of length one with name of default notes
reference
}
\description{
Get the default notes reference for a repository
}
\examples{
\dontrun{
## Create and initialize a repository in a temporary directory
path <- tempfile(pattern="git2r-")
dir.create(path)
repo <- init(path)
config(repo, user.name="Alice", user.email="alice@example.org")

## View default notes reference
note_default_ref(repo)
}
}
\keyword{methods}

