% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/commit.R
\name{commit}
\alias{commit}
\title{Commit}
\usage{
commit(repo = ".", message = NULL, all = FALSE, session = FALSE,
  author = NULL, committer = NULL)
}
\arguments{
\item{repo}{a path to a repository or a \code{git_repository}
object. Default is '.'}

\item{message}{The commit message.}

\item{all}{Stage modified and deleted files. Files not added to
Git are not affected.}

\item{session}{Add sessionInfo to commit message. Default is
FALSE.}

\item{author}{Signature with author and author time of commit.}

\item{committer}{Signature with committer and commit time of
commit.}
}
\value{
A list of class \code{git_commit} with entries:
\describe{
  \item{sha}{
    The 40 character hexadecimal string of the SHA-1
  }
  \item{author}{
    An author signature
  }
  \item{committer}{
    The committer signature
  }
  \item{summary}{
    The short "summary" of a git commit message, comprising the first
    paragraph of the message with whitespace trimmed and squashed.
  }
  \item{message}{
    The message of a commit
  }
  \item{repo}{
    The \code{git_repository} object that contains the commit
  }
}
}
\description{
Commit
}
\examples{
\dontrun{
## Initialize a repository
path <- tempfile(pattern="git2r-")
dir.create(path)
repo <- init(path)

## Config user
config(repo, user.name="Alice", user.email="alice@example.org")

## Write to a file and commit
writeLines("Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do",
           file.path(path, "example.txt"))
add(repo, "example.txt")
commit(repo, "First commit message")
}
}
